
:: Location of TBB queried by the FindTBB CMake module.
set "TBB_ROOT=%LIBRARY_PREFIX%"

if %tbb%==2021 (echo "Building with TBB 2021") else (echo "Building with TBB 2020")

:: Starting with TBB 2021, we have to specify the link library's path explicitly when running CMake.
if %tbb%==2021 (set tbb_lib_cmake="-Dtbb_LIBRARY_RELEASE=%PREFIX%/lib/tbb12.lib")

::##############################################################################
:: OpenImageDenoise
::##############################################################################

cd %SRC_DIR%\oidn

:: Patch FindTBB.cmake script (line 401): Conda package 'tbb' contains no debug dlls. Do not look for them.
echo "Patching CMake script"
python -c "f=open('cmake/FindTBB.cmake', 'r'); s=f.read().replace('rk_tbb_find_library(\"${COMPONENT_NAME}\" DEBUG)', '#rk_tbb_find_library(\"${COMPONENT_NAME}\" DEBUG)'); f.close(); f=open('cmake/FindTBB.cmake', 'w'); f.write(s); f.close();" > python_output.txt 2>&1
if %tbb%==2021 (python -c "f=open('cmake/FindTBB.cmake', 'r'); s=f.read().replace('file(GLOB DLL_NAMES', 'if (${COMPONENT_NAME} STREQUAL \"tbb\")\nset(LIB_NAME \"../../bin/tbb12\")\nendif()\nfile(GLOB DLL_NAMES'); f.close(); f=open('cmake/FindTBB.cmake', 'w'); f.write(s); f.close();" > python_output.txt 2>&1)
if errorlevel 1 exit 1

mkdir build
cd build

echo "Configuring oidn..."
cmake ^
    -G "Ninja" ^
    %tbb_lib_cmake% ^
    -DCMAKE_INSTALL_PREFIX=%LIBRARY_PREFIX% ^
    -DCMAKE_BUILD_TYPE=Release ^
    -DCMAKE_INSTALL_LIBDIR=lib ^
    -DOIDN_APPS=OFF ^
    -DISPC_EXECUTABLE=%SRC_DIR%/ispc/bin/ispc ^
    .. > cmake_output.txt 2>&1
if errorlevel 1 exit 1
cmake -LA .
if errorlevel 1 exit 1

echo "Building oidn..."
cmake --build . -j
if errorlevel 1 exit 1

echo "Installing oidn..."
cmake --install .
if errorlevel 1 exit 1

::##############################################################################
:: Embree
::##############################################################################

cd %SRC_DIR%\embree
mkdir build
cd build

echo "Configuring embree..."
cmake ^
    -G "Ninja" ^
    %tbb_lib_cmake% ^
    -DCMAKE_INSTALL_PREFIX=%LIBRARY_PREFIX% ^
    -DCMAKE_BUILD_TYPE=Release ^
    -DCMAKE_INSTALL_LIBDIR=lib ^
    -DEMBREE_IGNORE_CMAKE_CXX_FLAGS=OFF ^
    -DEMBREE_LIBRARY_NAME=embree_ovito ^
    -DEMBREE_ISPC_EXECUTABLE=%SRC_DIR%/ispc/bin/ispc ^
    -DEMBREE_TUTORIALS=OFF ^
    -DEMBREE_MAX_ISA=AVX2 ^
    .. > cmake_output.txt 2>&1
if errorlevel 1 exit 1
cmake -LA .

echo "Building embree..."
cmake --build . -j
if errorlevel 1 exit 1

echo "Installing embree..."
cmake --install .
if errorlevel 1 exit 1

::##############################################################################
:: rkcommon
::##############################################################################

cd %SRC_DIR%\rkcommon
mkdir build
cd build

echo "Configuring rkcommon..."
cmake ^
    -G "Ninja" ^
    -DCMAKE_INSTALL_PREFIX=%LIBRARY_PREFIX% ^
    -DCMAKE_BUILD_TYPE=Release ^
    -DCMAKE_INSTALL_LIBDIR=lib ^
    .. > cmake_output.txt 2>&1
if errorlevel 1 exit 1
cmake -LA .

echo "Building rkcommon..."
cmake --build . -j
if errorlevel 1 exit 1

echo "Installing rkcommon..."
cmake --install .
if errorlevel 1 exit 1

::##############################################################################
:: OpenVKL
::##############################################################################

cd %SRC_DIR%\openvkl
mkdir build
cd build

echo "Configuring openvkl..."
cmake ^
    -G "Ninja" ^
    -DCMAKE_INSTALL_PREFIX=%LIBRARY_PREFIX% ^
    -DCMAKE_BUILD_TYPE=Release ^
    -DCMAKE_INSTALL_LIBDIR=lib ^
    -DISPC_EXECUTABLE=%SRC_DIR%/ispc/bin/ispc ^
    -DBUILD_TESTING=OFF ^
    -DBUILD_EXAMPLES=OFF ^
    .. > cmake_output.txt 2>&1
if errorlevel 1 exit 1
cmake -LA .

echo "Building openvkl..."
cmake --build . -j
if errorlevel 1 exit 1

echo "Installing openvkl..."
cmake --install .
if errorlevel 1 exit 1


::##############################################################################
:: OSPRay
::##############################################################################

cd %SRC_DIR%\ospray
mkdir build
cd build

echo "Configuring ospray..."
cmake ^
    -G "Ninja" ^
    -DCMAKE_INSTALL_PREFIX=%LIBRARY_PREFIX% ^
    -DCMAKE_BUILD_TYPE=Release ^
    -DCMAKE_INSTALL_LIBDIR=lib ^
    -DISPC_EXECUTABLE=%SRC_DIR%/ispc/bin/ispc ^
    -DOSPRAY_APPS_TESTING=OFF ^
    -DOSPRAY_ENABLE_APPS=OFF ^
    -DOSPRAY_BUILD_ISA=AVX2 ^
    -DOSPRAY_MODULE_DENOISER=ON ^
    .. > cmake_output.txt 2>&1
if errorlevel 1 exit 1
cmake -LA .

echo "Building ospray..."
cmake --build . -j
if errorlevel 1 exit 1

echo "Installing ospray..."
cmake --install .
if errorlevel 1 exit 1

echo "Cleaning up..."
:: Remove stuff we don't want in the conda package.
del /q %LIBRARY_PREFIX%\bin\rkcommon_test_suite.exe
del /q %LIBRARY_PREFIX%\share\doc\embree3\readme.pdf
del /q %LIBRARY_PREFIX%\share\doc\OpenImageDenoise\readme.pdf
if errorlevel 1 exit 1

echo "Done"