//
// render/scivis/SciVis_ispc.h
// (Header automatically generated by the ispc compiler.)
// DO NOT EDIT THIS FILE.
//

#pragma once
#include <stdint.h>

#if !defined(__cplusplus)
#if defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 199901L)
#include <stdbool.h>
#else
typedef int bool;
#endif
#endif



#ifdef __cplusplus
namespace ispc { /* namespace */
#endif // __cplusplus
///////////////////////////////////////////////////////////////////////////
// Enumerator types with external visibility from ispc code
///////////////////////////////////////////////////////////////////////////

#ifndef __ISPC_ENUM_FrameBufferType__
#define __ISPC_ENUM_FrameBufferType__
enum FrameBufferType {
    FRAMEBUFFER_TYPE_LOCAL = 0,
    FRAMEBUFFER_TYPE_SPARSE = 1,
    FRAMEBUFFER_TYPE_UNKNOWN = 2 
};
#endif

#ifndef __ISPC_ENUM_CameraType__
#define __ISPC_ENUM_CameraType__
enum CameraType {
    CAMERA_TYPE_PERSPECTIVE = 0,
    CAMERA_TYPE_ORTHOGRAPHIC = 1,
    CAMERA_TYPE_PANORAMIC = 2,
    CAMERA_TYPE_UNKNOWN = 3 
};
#endif

#ifndef __ISPC_ENUM_GeometryType__
#define __ISPC_ENUM_GeometryType__
enum GeometryType {
    GEOMETRY_TYPE_TRIANGLE_MESH = 0,
    GEOMETRY_TYPE_QUAD_MESH = 1,
    GEOMETRY_TYPE_BOXES = 2,
    GEOMETRY_TYPE_SPHERES = 3,
    GEOMETRY_TYPE_PLANES = 4,
    GEOMETRY_TYPE_CURVES = 5,
    GEOMETRY_TYPE_SUBDIVISION = 6,
    GEOMETRY_TYPE_UNKNOWN = 7 
};
#endif

#ifndef __ISPC_ENUM_FeatureFlagsGeometry__
#define __ISPC_ENUM_FeatureFlagsGeometry__
enum FeatureFlagsGeometry {
    FFG_NONE = 0,
    FFG_MOTION_BLUR = 1,
    FFG_TRIANGLE = 2,
    FFG_QUAD = 4,
    FFG_GRID = 8,
    FFG_SUBDIVISION = 16,
    FFG_CONE_LINEAR_CURVE = 32,
    FFG_ROUND_LINEAR_CURVE = 64,
    FFG_FLAT_LINEAR_CURVE = 128,
    FFG_LINEAR_CURVE = 224,
    FFG_ROUND_BEZIER_CURVE = 256,
    FFG_FLAT_BEZIER_CURVE = 512,
    FFG_NORMAL_ORIENTED_BEZIER_CURVE = 1024,
    FFG_BEZIER_CURVE = 1792,
    FFG_ROUND_BSPLINE_CURVE = 2048,
    FFG_FLAT_BSPLINE_CURVE = 4096,
    FFG_NORMAL_ORIENTED_BSPLINE_CURVE = 8192,
    FFG_BSPLINE_CURVE = 14336,
    FFG_ROUND_HERMITE_CURVE = 16384,
    FFG_FLAT_HERMITE_CURVE = 32768,
    FFG_NORMAL_ORIENTED_HERMITE_CURVE = 65536,
    FFG_HERMITE_CURVE = 114688,
    FFG_ROUND_CATMULL_ROM_CURVE = 131072,
    FFG_FLAT_CATMULL_ROM_CURVE = 262144,
    FFG_NORMAL_ORIENTED_CATMULL_ROM_CURVE = 524288,
    FFG_CATMULL_ROM_CURVE = 917504,
    FFG_SPHERE = 1048576,
    FFG_DISC_POINT = 2097152,
    FFG_ORIENTED_DISC_POINT = 4194304,
    FFG_SPHERES = 7340032,
    FFG_CURVES = 1048544,
    FFG_OSPRAY_MASK = 436207616,
    FFG_BOX = 201326592,
    FFG_PLANE = 100663296,
    FFG_ISOSURFACE = 335544320,
    FFG_ALL = -1 
};
#endif

#ifndef __ISPC_ENUM_FeatureFlagsOther__
#define __ISPC_ENUM_FeatureFlagsOther__
enum FeatureFlagsOther {
    FFO_NONE = 0,
    FFO_FB_LOCAL = 1,
    FFO_FB_SPARSE = 2,
    FFO_CAMERA_PERSPECTIVE = 4,
    FFO_CAMERA_ORTHOGRAPHIC = 8,
    FFO_CAMERA_PANORAMIC = 16,
    FFO_LIGHT_AMBIENT = 32,
    FFO_LIGHT_CYLINDER = 64,
    FFO_LIGHT_DIRECTIONAL = 128,
    FFO_LIGHT_HDRI = 256,
    FFO_LIGHT_POINT = 512,
    FFO_LIGHT_QUAD = 1024,
    FFO_LIGHT_SPOT = 2048,
    FFO_LIGHT_GEOMETRY = 4096,
    FFO_MATERIAL_ALLOY = 8192,
    FFO_MATERIAL_CARPAINT = 16384,
    FFO_MATERIAL_GLASS = 32768,
    FFO_MATERIAL_LUMINOUS = 65536,
    FFO_MATERIAL_METAL = 131072,
    FFO_MATERIAL_METALLICPAINT = 262144,
    FFO_MATERIAL_MIX = 524288,
    FFO_MATERIAL_OBJ = 1048576,
    FFO_MATERIAL_PLASTIC = 2097152,
    FFO_MATERIAL_PRINCIPLED = 4194304,
    FFO_MATERIAL_THINGLASS = 8388608,
    FFO_MATERIAL_VELVET = 16777216,
    FFO_TEXTURE_IN_MATERIAL = 33554432,
    FFO_TEXTURE_IN_RENDERER = 67108864,
    FFO_VOLUME_IN_SCENE = 134217728,
    FFO_VOLUME_SCIVIS_SHADING = 268435456,
    FFO_CAMERA_MOTION_BLUR = 536870912,
    FFO_ALL = -1 
};
#endif

#ifndef __ISPC_ENUM_RTCError__
#define __ISPC_ENUM_RTCError__
enum RTCError {
    RTC_ERROR_NONE = 0,
    RTC_ERROR_UNKNOWN = 1,
    RTC_ERROR_INVALID_ARGUMENT = 2,
    RTC_ERROR_INVALID_OPERATION = 3,
    RTC_ERROR_OUT_OF_MEMORY = 4,
    RTC_ERROR_UNSUPPORTED_CPU = 5,
    RTC_ERROR_CANCELLED = 6 
};
#endif

#ifndef __ISPC_ENUM_RTCDeviceProperty__
#define __ISPC_ENUM_RTCDeviceProperty__
enum RTCDeviceProperty {
    RTC_DEVICE_PROPERTY_VERSION = 0,
    RTC_DEVICE_PROPERTY_VERSION_MAJOR = 1,
    RTC_DEVICE_PROPERTY_VERSION_MINOR = 2,
    RTC_DEVICE_PROPERTY_VERSION_PATCH = 3,
    RTC_DEVICE_PROPERTY_NATIVE_RAY4_SUPPORTED = 32,
    RTC_DEVICE_PROPERTY_NATIVE_RAY8_SUPPORTED = 33,
    RTC_DEVICE_PROPERTY_NATIVE_RAY16_SUPPORTED = 34,
    RTC_DEVICE_PROPERTY_BACKFACE_CULLING_CURVES_ENABLED = 63,
    RTC_DEVICE_PROPERTY_RAY_MASK_SUPPORTED = 64,
    RTC_DEVICE_PROPERTY_BACKFACE_CULLING_ENABLED = 65,
    RTC_DEVICE_PROPERTY_FILTER_FUNCTION_SUPPORTED = 66,
    RTC_DEVICE_PROPERTY_IGNORE_INVALID_RAYS_ENABLED = 67,
    RTC_DEVICE_PROPERTY_COMPACT_POLYS_ENABLED = 68,
    RTC_DEVICE_PROPERTY_TRIANGLE_GEOMETRY_SUPPORTED = 96,
    RTC_DEVICE_PROPERTY_QUAD_GEOMETRY_SUPPORTED = 97,
    RTC_DEVICE_PROPERTY_SUBDIVISION_GEOMETRY_SUPPORTED = 98,
    RTC_DEVICE_PROPERTY_CURVE_GEOMETRY_SUPPORTED = 99,
    RTC_DEVICE_PROPERTY_USER_GEOMETRY_SUPPORTED = 100,
    RTC_DEVICE_PROPERTY_TASKING_SYSTEM = 128,
    RTC_DEVICE_PROPERTY_JOIN_COMMIT_SUPPORTED = 129,
    RTC_DEVICE_PROPERTY_PARALLEL_COMMIT_SUPPORTED = 130 
};
#endif

#ifndef __ISPC_ENUM_RTCBufferType__
#define __ISPC_ENUM_RTCBufferType__
enum RTCBufferType {
    RTC_BUFFER_TYPE_INDEX = 0,
    RTC_BUFFER_TYPE_VERTEX = 1,
    RTC_BUFFER_TYPE_VERTEX_ATTRIBUTE = 2,
    RTC_BUFFER_TYPE_NORMAL = 3,
    RTC_BUFFER_TYPE_TANGENT = 4,
    RTC_BUFFER_TYPE_NORMAL_DERIVATIVE = 5,
    RTC_BUFFER_TYPE_GRID = 8,
    RTC_BUFFER_TYPE_FACE = 16,
    RTC_BUFFER_TYPE_LEVEL = 17,
    RTC_BUFFER_TYPE_EDGE_CREASE_INDEX = 18,
    RTC_BUFFER_TYPE_EDGE_CREASE_WEIGHT = 19,
    RTC_BUFFER_TYPE_VERTEX_CREASE_INDEX = 20,
    RTC_BUFFER_TYPE_VERTEX_CREASE_WEIGHT = 21,
    RTC_BUFFER_TYPE_HOLE = 22,
    RTC_BUFFER_TYPE_TRANSFORM = 23,
    RTC_BUFFER_TYPE_FLAGS = 32 
};
#endif

#ifndef __ISPC_ENUM_RTCFormat__
#define __ISPC_ENUM_RTCFormat__
enum RTCFormat {
    RTC_FORMAT_UNDEFINED = 0,
    RTC_FORMAT_UCHAR = 4097,
    RTC_FORMAT_UCHAR2 = 4098,
    RTC_FORMAT_UCHAR3 = 4099,
    RTC_FORMAT_UCHAR4 = 4100,
    RTC_FORMAT_CHAR = 8193,
    RTC_FORMAT_CHAR2 = 8194,
    RTC_FORMAT_CHAR3 = 8195,
    RTC_FORMAT_CHAR4 = 8196,
    RTC_FORMAT_USHORT = 12289,
    RTC_FORMAT_USHORT2 = 12290,
    RTC_FORMAT_USHORT3 = 12291,
    RTC_FORMAT_USHORT4 = 12292,
    RTC_FORMAT_SHORT = 16385,
    RTC_FORMAT_SHORT2 = 16386,
    RTC_FORMAT_SHORT3 = 16387,
    RTC_FORMAT_SHORT4 = 16388,
    RTC_FORMAT_UINT = 20481,
    RTC_FORMAT_UINT2 = 20482,
    RTC_FORMAT_UINT3 = 20483,
    RTC_FORMAT_UINT4 = 20484,
    RTC_FORMAT_INT = 24577,
    RTC_FORMAT_INT2 = 24578,
    RTC_FORMAT_INT3 = 24579,
    RTC_FORMAT_INT4 = 24580,
    RTC_FORMAT_ULLONG = 28673,
    RTC_FORMAT_ULLONG2 = 28674,
    RTC_FORMAT_ULLONG3 = 28675,
    RTC_FORMAT_ULLONG4 = 28676,
    RTC_FORMAT_LLONG = 32769,
    RTC_FORMAT_LLONG2 = 32770,
    RTC_FORMAT_LLONG3 = 32771,
    RTC_FORMAT_LLONG4 = 32772,
    RTC_FORMAT_FLOAT = 36865,
    RTC_FORMAT_FLOAT2 = 36866,
    RTC_FORMAT_FLOAT3 = 36867,
    RTC_FORMAT_FLOAT4 = 36868,
    RTC_FORMAT_FLOAT5 = 36869,
    RTC_FORMAT_FLOAT6 = 36870,
    RTC_FORMAT_FLOAT7 = 36871,
    RTC_FORMAT_FLOAT8 = 36872,
    RTC_FORMAT_FLOAT9 = 36873,
    RTC_FORMAT_FLOAT10 = 36874,
    RTC_FORMAT_FLOAT11 = 36875,
    RTC_FORMAT_FLOAT12 = 36876,
    RTC_FORMAT_FLOAT13 = 36877,
    RTC_FORMAT_FLOAT14 = 36878,
    RTC_FORMAT_FLOAT15 = 36879,
    RTC_FORMAT_FLOAT16 = 36880,
    RTC_FORMAT_FLOAT2X2_ROW_MAJOR = 37154,
    RTC_FORMAT_FLOAT2X3_ROW_MAJOR = 37155,
    RTC_FORMAT_FLOAT2X4_ROW_MAJOR = 37156,
    RTC_FORMAT_FLOAT3X2_ROW_MAJOR = 37170,
    RTC_FORMAT_FLOAT3X3_ROW_MAJOR = 37171,
    RTC_FORMAT_FLOAT3X4_ROW_MAJOR = 37172,
    RTC_FORMAT_FLOAT4X2_ROW_MAJOR = 37186,
    RTC_FORMAT_FLOAT4X3_ROW_MAJOR = 37187,
    RTC_FORMAT_FLOAT4X4_ROW_MAJOR = 37188,
    RTC_FORMAT_FLOAT2X2_COLUMN_MAJOR = 37410,
    RTC_FORMAT_FLOAT2X3_COLUMN_MAJOR = 37411,
    RTC_FORMAT_FLOAT2X4_COLUMN_MAJOR = 37412,
    RTC_FORMAT_FLOAT3X2_COLUMN_MAJOR = 37426,
    RTC_FORMAT_FLOAT3X3_COLUMN_MAJOR = 37427,
    RTC_FORMAT_FLOAT3X4_COLUMN_MAJOR = 37428,
    RTC_FORMAT_FLOAT4X2_COLUMN_MAJOR = 37442,
    RTC_FORMAT_FLOAT4X3_COLUMN_MAJOR = 37443,
    RTC_FORMAT_FLOAT4X4_COLUMN_MAJOR = 37444,
    RTC_FORMAT_GRID = 40961 
};
#endif

#ifndef __ISPC_ENUM_RTCSceneFlags__
#define __ISPC_ENUM_RTCSceneFlags__
enum RTCSceneFlags {
    RTC_SCENE_FLAG_NONE = 0,
    RTC_SCENE_FLAG_DYNAMIC = 1,
    RTC_SCENE_FLAG_COMPACT = 2,
    RTC_SCENE_FLAG_ROBUST = 4,
    RTC_SCENE_FLAG_FILTER_FUNCTION_IN_ARGUMENTS = 8 
};
#endif

#ifndef __ISPC_ENUM_RTCRayQueryFlags__
#define __ISPC_ENUM_RTCRayQueryFlags__
enum RTCRayQueryFlags {
    RTC_RAY_QUERY_FLAG_NONE = 0,
    RTC_RAY_QUERY_FLAG_INVOKE_ARGUMENT_FILTER = 2,
    RTC_RAY_QUERY_FLAG_INCOHERENT = 0,
    RTC_RAY_QUERY_FLAG_COHERENT = 65536 
};
#endif

#ifndef __ISPC_ENUM_RTCFeatureFlags__
#define __ISPC_ENUM_RTCFeatureFlags__
enum RTCFeatureFlags {
    RTC_FEATURE_FLAG_NONE = 0,
    RTC_FEATURE_FLAG_MOTION_BLUR = 1,
    RTC_FEATURE_FLAG_TRIANGLE = 2,
    RTC_FEATURE_FLAG_QUAD = 4,
    RTC_FEATURE_FLAG_GRID = 8,
    RTC_FEATURE_FLAG_SUBDIVISION = 16,
    RTC_FEATURE_FLAG_CONE_LINEAR_CURVE = 32,
    RTC_FEATURE_FLAG_ROUND_LINEAR_CURVE = 64,
    RTC_FEATURE_FLAG_FLAT_LINEAR_CURVE = 128,
    RTC_FEATURE_FLAG_ROUND_BEZIER_CURVE = 256,
    RTC_FEATURE_FLAG_FLAT_BEZIER_CURVE = 512,
    RTC_FEATURE_FLAG_NORMAL_ORIENTED_BEZIER_CURVE = 1024,
    RTC_FEATURE_FLAG_ROUND_BSPLINE_CURVE = 2048,
    RTC_FEATURE_FLAG_FLAT_BSPLINE_CURVE = 4096,
    RTC_FEATURE_FLAG_NORMAL_ORIENTED_BSPLINE_CURVE = 8192,
    RTC_FEATURE_FLAG_ROUND_HERMITE_CURVE = 16384,
    RTC_FEATURE_FLAG_FLAT_HERMITE_CURVE = 32768,
    RTC_FEATURE_FLAG_NORMAL_ORIENTED_HERMITE_CURVE = 65536,
    RTC_FEATURE_FLAG_ROUND_CATMULL_ROM_CURVE = 131072,
    RTC_FEATURE_FLAG_FLAT_CATMULL_ROM_CURVE = 262144,
    RTC_FEATURE_FLAG_NORMAL_ORIENTED_CATMULL_ROM_CURVE = 524288,
    RTC_FEATURE_FLAG_SPHERE_POINT = 1048576,
    RTC_FEATURE_FLAG_DISC_POINT = 2097152,
    RTC_FEATURE_FLAG_ORIENTED_DISC_POINT = 4194304,
    RTC_FEATURE_FLAG_POINT = 7340032,
    RTC_FEATURE_FLAG_ROUND_CURVES = 149824,
    RTC_FEATURE_FLAG_FLAT_CURVES = 299648,
    RTC_FEATURE_FLAG_NORMAL_ORIENTED_CURVES = 599040,
    RTC_FEATURE_FLAG_LINEAR_CURVES = 224,
    RTC_FEATURE_FLAG_BEZIER_CURVES = 1792,
    RTC_FEATURE_FLAG_BSPLINE_CURVES = 14336,
    RTC_FEATURE_FLAG_HERMITE_CURVES = 114688,
    RTC_FEATURE_FLAG_CURVES = 1048544,
    RTC_FEATURE_FLAG_INSTANCE = 8388608,
    RTC_FEATURE_FLAG_FILTER_FUNCTION_IN_ARGUMENTS = 16777216,
    RTC_FEATURE_FLAG_FILTER_FUNCTION_IN_GEOMETRY = 33554432,
    RTC_FEATURE_FLAG_FILTER_FUNCTION = 50331648,
    RTC_FEATURE_FLAG_USER_GEOMETRY_CALLBACK_IN_ARGUMENTS = 67108864,
    RTC_FEATURE_FLAG_USER_GEOMETRY_CALLBACK_IN_GEOMETRY = 134217728,
    RTC_FEATURE_FLAG_USER_GEOMETRY = 201326592,
    RTC_FEATURE_FLAG_32_BIT_RAY_MASK = 268435456,
    RTC_FEATURE_FLAG_INSTANCE_ARRAY = 536870912,
    RTC_FEATURE_FLAG_ALL = -1 
};
#endif

#ifndef __ISPC_ENUM_RTCGeometryType__
#define __ISPC_ENUM_RTCGeometryType__
enum RTCGeometryType {
    RTC_GEOMETRY_TYPE_TRIANGLE = 0,
    RTC_GEOMETRY_TYPE_QUAD = 1,
    RTC_GEOMETRY_TYPE_GRID = 2,
    RTC_GEOMETRY_TYPE_SUBDIVISION = 8,
    RTC_GEOMETRY_TYPE_CONE_LINEAR_CURVE = 15,
    RTC_GEOMETRY_TYPE_FLAT_LINEAR_CURVE = 17,
    RTC_GEOMETRY_TYPE_ROUND_LINEAR_CURVE = 16,
    RTC_GEOMETRY_TYPE_ROUND_BEZIER_CURVE = 24,
    RTC_GEOMETRY_TYPE_FLAT_BEZIER_CURVE = 25,
    RTC_GEOMETRY_TYPE_NORMAL_ORIENTED_BEZIER_CURVE = 26,
    RTC_GEOMETRY_TYPE_ROUND_BSPLINE_CURVE = 32,
    RTC_GEOMETRY_TYPE_FLAT_BSPLINE_CURVE = 33,
    RTC_GEOMETRY_TYPE_NORMAL_ORIENTED_BSPLINE_CURVE = 34,
    RTC_GEOMETRY_TYPE_ROUND_HERMITE_CURVE = 40,
    RTC_GEOMETRY_TYPE_FLAT_HERMITE_CURVE = 41,
    RTC_GEOMETRY_TYPE_NORMAL_ORIENTED_HERMITE_CURVE = 42,
    RTC_GEOMETRY_TYPE_SPHERE_POINT = 50,
    RTC_GEOMETRY_TYPE_DISC_POINT = 51,
    RTC_GEOMETRY_TYPE_ORIENTED_DISC_POINT = 52,
    RTC_GEOMETRY_TYPE_ROUND_CATMULL_ROM_CURVE = 58,
    RTC_GEOMETRY_TYPE_FLAT_CATMULL_ROM_CURVE = 59,
    RTC_GEOMETRY_TYPE_NORMAL_ORIENTED_CATMULL_ROM_CURVE = 60,
    RTC_GEOMETRY_TYPE_USER = 120,
    RTC_GEOMETRY_TYPE_INSTANCE = 121,
    RTC_GEOMETRY_TYPE_INSTANCE_ARRAY = 122 
};
#endif

#ifndef __ISPC_ENUM_RTCBuildQuality__
#define __ISPC_ENUM_RTCBuildQuality__
enum RTCBuildQuality {
    RTC_BUILD_QUALITY_LOW = 0,
    RTC_BUILD_QUALITY_MEDIUM = 1,
    RTC_BUILD_QUALITY_HIGH = 2,
    RTC_BUILD_QUALITY_REFIT = 3 
};
#endif

#ifndef __ISPC_ENUM_RTCSubdivisionMode__
#define __ISPC_ENUM_RTCSubdivisionMode__
enum RTCSubdivisionMode {
    RTC_SUBDIVISION_MODE_NO_BOUNDARY = 0,
    RTC_SUBDIVISION_MODE_SMOOTH_BOUNDARY = 1,
    RTC_SUBDIVISION_MODE_PIN_CORNERS = 2,
    RTC_SUBDIVISION_MODE_PIN_BOUNDARY = 3,
    RTC_SUBDIVISION_MODE_PIN_ALL = 4 
};
#endif


#ifndef __ISPC_ALIGN__
#if defined(__clang__) || !defined(_MSC_VER)
// Clang, GCC, ICC
#define __ISPC_ALIGN__(s) __attribute__((aligned(s)))
#define __ISPC_ALIGNED_STRUCT__(s) struct __ISPC_ALIGN__(s)
#else
// Visual Studio
#define __ISPC_ALIGN__(s) __declspec(align(s))
#define __ISPC_ALIGNED_STRUCT__(s) __ISPC_ALIGN__(s) struct
#endif
#endif

#ifndef __ISPC_STRUCT_vec3ui__
#define __ISPC_STRUCT_vec3ui__
struct vec3ui {
    uint32_t x;
    uint32_t y;
    uint32_t z;
};
#endif

#ifndef __ISPC_STRUCT_vec4f__
#define __ISPC_STRUCT_vec4f__
struct vec4f {
    float x;
    float y;
    float z;
    float w;
};
#endif

#ifndef __ISPC_STRUCT_Renderer__
#define __ISPC_STRUCT_Renderer__
struct Renderer {
    int32_t spp;
    struct vec4f bgColor;
    struct Texture2D * backplate;
    struct Texture2D * maxDepthTexture;
    uint32_t maxDepth;
    float minContribution;
    int32_t numMaterials;
    struct Material *  * material;
    struct PixelFilter * pixelFilter;
    float mipBiasFactor;
};
#endif

#ifndef __ISPC_STRUCT_vec2i__
#define __ISPC_STRUCT_vec2i__
struct vec2i {
    int32_t x;
    int32_t y;
};
#endif

#ifndef __ISPC_STRUCT_vec2f__
#define __ISPC_STRUCT_vec2f__
struct vec2f {
    float x;
    float y;
};
#endif

#ifndef __ISPC_STRUCT_FrameBuffer__
#define __ISPC_STRUCT_FrameBuffer__
struct FrameBuffer {
    enum FrameBufferType type;
    struct RenderTaskDesc ( * getRenderTaskDesc)(struct FrameBuffer * fb, const uint32_t taskID);

#if defined(__cplusplus)
    void ( * accumulateSample)(struct FrameBuffer * fb, const struct v8_varying_ScreenSample &sample, struct RenderTaskDesc &taskDesc);
#else
    void ( * accumulateSample)(struct FrameBuffer * fb, const struct v8_varying_ScreenSample *sample, struct RenderTaskDesc *taskDesc);
#endif // accumulateSample field

#if defined(__cplusplus)
    void ( * completeTask)(struct FrameBuffer * fb, const struct RenderTaskDesc &taskDesc);
#else
    void ( * completeTask)(struct FrameBuffer * fb, const struct RenderTaskDesc *taskDesc);
#endif // completeTask field
    struct vec2i size;
    struct vec2f rcpSize;
    struct vec2i renderTaskSize;
    int32_t frameID;
    int32_t targetFrames;
    uint32_t channels;
    uint32_t cancelRender;
    uint32_t numPixelsRendered;
    bool accumulateVariance;
};
#endif

#ifndef __ISPC_STRUCT_v8_varying_vec3i__
#define __ISPC_STRUCT_v8_varying_vec3i__
__ISPC_ALIGNED_STRUCT__(32) v8_varying_vec3i {
    __ISPC_ALIGN__(32)     int32_t x[8];
    __ISPC_ALIGN__(32)     int32_t y[8];
    __ISPC_ALIGN__(32)     int32_t z[8];
};
#endif

#ifndef __ISPC_STRUCT_v8_varying_vec2f__
#define __ISPC_STRUCT_v8_varying_vec2f__
__ISPC_ALIGNED_STRUCT__(32) v8_varying_vec2f {
    __ISPC_ALIGN__(32)     float x[8];
    __ISPC_ALIGN__(32)     float y[8];
};
#endif

#ifndef __ISPC_STRUCT_v8_varying_vec3f__
#define __ISPC_STRUCT_v8_varying_vec3f__
__ISPC_ALIGNED_STRUCT__(32) v8_varying_vec3f {
    __ISPC_ALIGN__(32)     float x[8];
    __ISPC_ALIGN__(32)     float y[8];
    __ISPC_ALIGN__(32)     float z[8];
};
#endif

#ifndef __ISPC_STRUCT_v8_varying_Ray__
#define __ISPC_STRUCT_v8_varying_Ray__
__ISPC_ALIGNED_STRUCT__(32) v8_varying_Ray {
    struct v8_varying_vec3f org;
    __ISPC_ALIGN__(32)     float t0[8];
    struct v8_varying_vec3f dir;
    __ISPC_ALIGN__(32)     float time[8];
    __ISPC_ALIGN__(32)     float t[8];
    __ISPC_ALIGN__(32)     uint32_t mask[8];
    __ISPC_ALIGN__(32)     uint32_t rayID[8];
    __ISPC_ALIGN__(32)     uint32_t flags[8];
    struct v8_varying_vec3f Ng;
    __ISPC_ALIGN__(32)     float u[8];
    __ISPC_ALIGN__(32)     float v[8];
    __ISPC_ALIGN__(32)     uint32_t primID[8];
    __ISPC_ALIGN__(32)     uint32_t geomID[8];
    __ISPC_ALIGN__(32)     uint32_t instID[8];
    __ISPC_ALIGN__(32)     uint32_t instPrimID[8];
};
#endif

#ifndef __ISPC_STRUCT_v8_varying_RayCone__
#define __ISPC_STRUCT_v8_varying_RayCone__
__ISPC_ALIGNED_STRUCT__(32) v8_varying_RayCone {
    __ISPC_ALIGN__(32)     float width[8];
    __ISPC_ALIGN__(32)     float dwdt[8];
};
#endif

#ifndef __ISPC_STRUCT_v8_varying_ScreenSample__
#define __ISPC_STRUCT_v8_varying_ScreenSample__
__ISPC_ALIGNED_STRUCT__(32) v8_varying_ScreenSample {
    struct v8_varying_vec3i sampleID;
    struct v8_varying_vec2f pos;
    struct v8_varying_Ray ray;
    struct v8_varying_RayCone rayCone;
    struct v8_varying_vec3f rgb;
    __ISPC_ALIGN__(32)     float alpha[8];
    __ISPC_ALIGN__(32)     float z[8];
    struct v8_varying_vec3f normal;
    struct v8_varying_vec3f albedo;
    __ISPC_ALIGN__(32)     uint32_t primID[8];
    __ISPC_ALIGN__(32)     uint32_t geomID[8];
    __ISPC_ALIGN__(32)     uint32_t instID[8];
};
#endif

#ifndef __ISPC_STRUCT_box2f__
#define __ISPC_STRUCT_box2f__
struct box2f {
    struct vec2f lower;
    struct vec2f upper;
};
#endif

#ifndef __ISPC_STRUCT_box1f__
#define __ISPC_STRUCT_box1f__
struct box1f {
    float lower;
    float upper;
};
#endif

#ifndef __ISPC_STRUCT_Camera__
#define __ISPC_STRUCT_Camera__
struct Camera {
    enum CameraType type;

#if defined(__cplusplus)
    void ( * initRay)(const struct Camera * __anon_parameter_0, struct v8_varying_Ray &ray, struct v8_varying_RayCone &rayCone, const struct CameraSample &sample);
#else
    void ( * initRay)(const struct Camera * __anon_parameter_0, struct v8_varying_Ray *ray, struct v8_varying_RayCone *rayCone, const struct CameraSample *sample);
#endif // initRay field
    float nearClip;
    struct box2f subImage;
    struct box1f shutter;
    bool globalShutter;
    bool motionBlur;
    bool needLensSample;
    bool needTimeSample;
    bool rollingShutterHorizontal;
    float rollingShutterDuration;
    struct RTCSceneTy * scene;
};
#endif

#ifndef __ISPC_STRUCT_World__
#define __ISPC_STRUCT_World__
struct World {
    struct Instance *  * instances;
    int32_t numInvertedClippers;
    struct RTCSceneTy * embreeSceneHandleGeometries;
    struct RTCSceneTy * embreeSceneHandleClippers;
    struct SciVisData * scivisData;
    struct PathTracerData * pathtracerData;
};
#endif

#ifndef __ISPC_STRUCT_vec3f__
#define __ISPC_STRUCT_vec3f__
struct vec3f {
    float x;
    float y;
    float z;
};
#endif

#ifndef __ISPC_STRUCT_LinearSpace3f__
#define __ISPC_STRUCT_LinearSpace3f__
struct LinearSpace3f {
    struct vec3f vx;
    struct vec3f vy;
    struct vec3f vz;
};
#endif

#ifndef __ISPC_STRUCT_AffineSpace3f__
#define __ISPC_STRUCT_AffineSpace3f__
struct AffineSpace3f {
    struct LinearSpace3f l;
    struct vec3f p;
};
#endif

#ifndef __ISPC_STRUCT_Instance__
#define __ISPC_STRUCT_Instance__
struct Instance {
    struct Group * group;
    struct RTCSceneTy * scene;
    uint32_t geomID;
    struct AffineSpace3f xfm;
    struct AffineSpace3f rcp_xfm;
    bool motionBlur;
    uint32_t userID;
};
#endif

#ifndef __ISPC_STRUCT_Group__
#define __ISPC_STRUCT_Group__
struct Group {
    struct GeometricModel *  * geometricModels;
    int32_t numGeometricModels;
    struct GeometricModel *  * clipModels;
    int32_t numClipModels;
};
#endif

#ifndef __ISPC_STRUCT_Data1D__
#define __ISPC_STRUCT_Data1D__
struct Data1D {
    uint8_t * addr;
    int64_t byteStride;
    uint32_t numItems;
    bool huge;
};
#endif

#ifndef __ISPC_STRUCT_GeometricModel__
#define __ISPC_STRUCT_GeometricModel__
struct GeometricModel {
    struct Geometry * geom;
    struct Data1D color;
    struct Data1D index;
    struct Material *  * material;
    uint32_t * materialID;
    uint32_t numMaterials;
    bool invertedNormals;
    float areaPDF;
    uint32_t userID;
};
#endif

#ifndef __ISPC_STRUCT_Geometry__
#define __ISPC_STRUCT_Geometry__
struct Geometry {
    enum GeometryType type;

#if defined(__cplusplus)
    void ( * postIntersect)(const struct Geometry * self, struct v8_varying_DifferentialGeometry &dg, const struct v8_varying_Ray &ray, int64_t flags);
#else
    void ( * postIntersect)(const struct Geometry * self, struct v8_varying_DifferentialGeometry *dg, const struct v8_varying_Ray *ray, int64_t flags);
#endif // postIntersect field

#if defined(__cplusplus)
    void ( * getAreas)(const struct Geometry * const __anon_parameter_0, const int32_t * const primIDs, const int32_t numPrims, const struct AffineSpace3f &xfm, float * const areas);
#else
    void ( * getAreas)(const struct Geometry * const __anon_parameter_0, const int32_t * const primIDs, const int32_t numPrims, const struct AffineSpace3f *xfm, float * const areas);
#endif // getAreas field

#if defined(__cplusplus)
    struct v8_varying_SampleAreaRes ( * sampleArea)(const struct Geometry * const __anon_parameter_0, const int32_t primID, const struct AffineSpace3f &xfm, const struct AffineSpace3f &rcp_xfm, const struct v8_varying_vec2f &s, const float time);
#else
    struct v8_varying_SampleAreaRes ( * sampleArea)(const struct Geometry * const __anon_parameter_0, const int32_t primID, const struct AffineSpace3f *xfm, const struct AffineSpace3f *rcp_xfm, const struct v8_varying_vec2f *s, const float time);
#endif // sampleArea field
    void ( * intersect)(const struct RTCIntersectFunctionNArguments * args, const bool isOcclusionTest);
    int32_t numPrimitives;
};
#endif

#ifndef __ISPC_STRUCT_v8_varying_vec4f__
#define __ISPC_STRUCT_v8_varying_vec4f__
__ISPC_ALIGNED_STRUCT__(32) v8_varying_vec4f {
    __ISPC_ALIGN__(32)     float x[8];
    __ISPC_ALIGN__(32)     float y[8];
    __ISPC_ALIGN__(32)     float z[8];
    __ISPC_ALIGN__(32)     float w[8];
};
#endif

#ifndef __ISPC_STRUCT_v8_varying_DifferentialGeometry__
#define __ISPC_STRUCT_v8_varying_DifferentialGeometry__
__ISPC_ALIGNED_STRUCT__(64) v8_varying_DifferentialGeometry {
    struct v8_varying_vec3f P;
    struct v8_varying_vec3f lP;
    struct v8_varying_vec3f Ng;
    struct v8_varying_vec3f Ns;
    struct v8_varying_vec3f dPds;
    struct v8_varying_vec3f dPdt;
    struct v8_varying_vec2f st;
    struct v8_varying_vec4f color;
    __ISPC_ALIGN__(32)     int32_t primID[8];
    __ISPC_ALIGN__(32)     float areaPDF[8];
    __ISPC_ALIGN__(32)     float epsilon[8];
    __ISPC_ALIGN__(64)     struct Material * material;
    const struct Renderer * renderer;
    __ISPC_ALIGN__(32)     uint32_t objID[8];
    __ISPC_ALIGN__(32)     uint32_t instID[8];
    __ISPC_ALIGN__(32)     float pixelFootprint[8];
};
#endif

#ifndef __ISPC_STRUCT_v8_varying_SampleAreaRes__
#define __ISPC_STRUCT_v8_varying_SampleAreaRes__
__ISPC_ALIGNED_STRUCT__(32) v8_varying_SampleAreaRes {
    struct v8_varying_vec3f pos;
    struct v8_varying_vec3f normal;
    struct v8_varying_vec2f st;
    __ISPC_ALIGN__(32)     float epsilon[8];
};
#endif

#ifndef __ISPC_STRUCT_RTCIntersectFunctionNArguments__
#define __ISPC_STRUCT_RTCIntersectFunctionNArguments__
struct RTCIntersectFunctionNArguments {
    int32_t * valid;
    void * geometryUserPtr;
    uint32_t primID;
    struct RTCRayQueryContext * context;
    struct RTCRayHitN * rayhit;
    uint32_t N;
    uint32_t geomID;
};
#endif

#ifndef __ISPC_STRUCT_RTCRayQueryContext__
#define __ISPC_STRUCT_RTCRayQueryContext__
struct RTCRayQueryContext {
    uint32_t instID[1];
    uint32_t instPrimID[1];
};
#endif

#ifndef __ISPC_STRUCT_SciVisData__
#define __ISPC_STRUCT_SciVisData__
struct SciVisData {
    struct Light *  * lights;
    uint32_t numLights;
    uint32_t numLightsVisibleOnly;
    struct vec3f aoColorPi;
};
#endif

#ifndef __ISPC_STRUCT_PathTracerData__
#define __ISPC_STRUCT_PathTracerData__
struct PathTracerData {
    struct Light *  * lights;
    uint32_t numLights;
    uint32_t numGeoLights;
    float * lightsCDF;
};
#endif

#ifndef __ISPC_STRUCT_FeatureFlags__
#define __ISPC_STRUCT_FeatureFlags__
struct FeatureFlags {
    enum FeatureFlagsGeometry geometry;
    enum FeatureFlagsOther other;
};
#endif

#ifndef __ISPC_STRUCT_RTCCollision__
#define __ISPC_STRUCT_RTCCollision__
struct RTCCollision {
    uint32_t geomID0;
    uint32_t primID0;
    uint32_t geomID1;
    uint32_t primID1;
};
#endif

#ifndef __ISPC_STRUCT_RTCRay__
#define __ISPC_STRUCT_RTCRay__
struct RTCRay {
    float org_x;
    float org_y;
    float org_z;
    float tnear;
    float dir_x;
    float dir_y;
    float dir_z;
    float time;
    float tfar;
    uint32_t mask;
    uint32_t id;
    uint32_t flags;
};
#endif

#ifndef __ISPC_STRUCT_RTCOccludedFunctionNArguments__
#define __ISPC_STRUCT_RTCOccludedFunctionNArguments__
struct RTCOccludedFunctionNArguments {
    int32_t * valid;
    void * geometryUserPtr;
    uint32_t primID;
    struct RTCRayQueryContext * context;
    struct RTCRayN * ray;
    uint32_t N;
    uint32_t geomID;
};
#endif

#ifndef __ISPC_STRUCT_RTCBounds__
#define __ISPC_STRUCT_RTCBounds__
struct RTCBounds {
    float lower_x;
    float lower_y;
    float lower_z;
    float align0;
    float upper_x;
    float upper_y;
    float upper_z;
    float align1;
};
#endif

#ifndef __ISPC_STRUCT_RTCLinearBounds__
#define __ISPC_STRUCT_RTCLinearBounds__
struct RTCLinearBounds {
    struct RTCBounds bounds0;
    struct RTCBounds bounds1;
};
#endif

#ifndef __ISPC_STRUCT_RTCInterpolateArguments__
#define __ISPC_STRUCT_RTCInterpolateArguments__
struct RTCInterpolateArguments {
    struct RTCGeometryTy * geometry;
    uint32_t primID;
    float u;
    float v;
    enum RTCBufferType bufferType;
    uint32_t bufferSlot;
    float * P;
    float * dPdu;
    float * dPdv;
    float * ddPdudu;
    float * ddPdvdv;
    float * ddPdudv;
    uint32_t valueCount;
};
#endif

#ifndef __ISPC_STRUCT_RTCInterpolateNArguments__
#define __ISPC_STRUCT_RTCInterpolateNArguments__
struct RTCInterpolateNArguments {
    struct RTCGeometryTy * geometry;
    const void * valid;
    const uint32_t * primIDs;
    const float * u;
    const float * v;
    uint32_t N;
    enum RTCBufferType bufferType;
    uint32_t bufferSlot;
    float * P;
    float * dPdu;
    float * dPdv;
    float * ddPdudu;
    float * ddPdvdv;
    float * ddPdudv;
    uint32_t valueCount;
};
#endif

#ifndef __ISPC_STRUCT_RTCHit__
#define __ISPC_STRUCT_RTCHit__
struct RTCHit {
    float Ng_x;
    float Ng_y;
    float Ng_z;
    float u;
    float v;
    uint32_t primID;
    uint32_t geomID;
    uint32_t instID[1];
    uint32_t instPrimID[1];
};
#endif

#ifndef __ISPC_STRUCT_RTCRayHit__
#define __ISPC_STRUCT_RTCRayHit__
struct RTCRayHit {
    struct RTCRay ray;
    struct RTCHit hit;
};
#endif

#ifndef __ISPC_STRUCT_RTCIntersectArguments__
#define __ISPC_STRUCT_RTCIntersectArguments__
struct RTCIntersectArguments {
    enum RTCRayQueryFlags flags;
    enum RTCFeatureFlags feature_mask;
    struct RTCRayQueryContext * context;
    void ( * filter)(const struct RTCFilterFunctionNArguments * args);
    void ( * intersect)(const struct RTCIntersectFunctionNArguments * args);
};
#endif

#ifndef __ISPC_STRUCT_RTCFilterFunctionNArguments__
#define __ISPC_STRUCT_RTCFilterFunctionNArguments__
struct RTCFilterFunctionNArguments {
    int32_t * valid;
    void * geometryUserPtr;
    struct RTCRayQueryContext * context;
    struct RTCRayN * ray;
    struct RTCHitN * hit;
    uint32_t N;
};
#endif

#ifndef __ISPC_STRUCT_RTCOccludedArguments__
#define __ISPC_STRUCT_RTCOccludedArguments__
struct RTCOccludedArguments {
    enum RTCRayQueryFlags flags;
    enum RTCFeatureFlags feature_mask;
    struct RTCRayQueryContext * context;
    void ( * filter)(const struct RTCFilterFunctionNArguments * args);
    void ( * occluded)(const struct RTCOccludedFunctionNArguments * args);
};
#endif

#ifndef __ISPC_STRUCT_RTCPointQuery__
#define __ISPC_STRUCT_RTCPointQuery__
struct RTCPointQuery {
    float x;
    float y;
    float z;
    float time;
    float radius;
};
#endif

#ifndef __ISPC_STRUCT_RTCPointQueryContext__
#define __ISPC_STRUCT_RTCPointQueryContext__
struct RTCPointQueryContext {
    float world2inst[1][16];
    float inst2world[1][16];
    uint32_t instID[1];
    uint32_t instPrimID[1];
    uint32_t instStackSize;
};
#endif

#ifndef __ISPC_STRUCT_RTCPointQueryFunctionArguments__
#define __ISPC_STRUCT_RTCPointQueryFunctionArguments__
struct RTCPointQueryFunctionArguments {
    struct RTCPointQuery * query;
    void * userPtr;
    uint32_t primID;
    uint32_t geomID;
    struct RTCPointQueryContext * context;
    float similarityScale;
};
#endif

#ifndef __ISPC_STRUCT_RTCBoundsFunctionArguments__
#define __ISPC_STRUCT_RTCBoundsFunctionArguments__
struct RTCBoundsFunctionArguments {
    void * geometryUserPtr;
    uint32_t primID;
    uint32_t timeStep;
    struct RTCBounds * bounds_o;
};
#endif

#ifndef __ISPC_STRUCT_RTCDisplacementFunctionNArguments__
#define __ISPC_STRUCT_RTCDisplacementFunctionNArguments__
struct RTCDisplacementFunctionNArguments {
    void * geometryUserPtr;
    struct RTCGeometryTy * geometry;
    uint32_t primID;
    uint32_t timeStep;
    const float * u;
    const float * v;
    const float * Ng_x;
    const float * Ng_y;
    const float * Ng_z;
    float * P_x;
    float * P_y;
    float * P_z;
    uint32_t N;
};
#endif

#ifndef __ISPC_STRUCT_RTCQuaternionDecomposition__
#define __ISPC_STRUCT_RTCQuaternionDecomposition__
struct RTCQuaternionDecomposition {
    float scale_x;
    float scale_y;
    float scale_z;
    float skew_xy;
    float skew_xz;
    float skew_yz;
    float shift_x;
    float shift_y;
    float shift_z;
    float quaternion_r;
    float quaternion_i;
    float quaternion_j;
    float quaternion_k;
    float translation_x;
    float translation_y;
    float translation_z;
};
#endif


///////////////////////////////////////////////////////////////////////////
// Functions exported from ispc code
///////////////////////////////////////////////////////////////////////////
#if defined(__cplusplus) && (! defined(__ISPC_NO_EXTERN_C) || !__ISPC_NO_EXTERN_C )
extern "C" {
#endif // __cplusplus
#if defined(__cplusplus)
    extern void SciVis_renderTaskLauncher(void * __anon_parameter_0, void * __anon_parameter_1, const struct vec3ui &itemDims, struct Renderer * renderer, struct FrameBuffer * fb, struct Camera * camera, struct World * world, const uint32_t * taskIDs, const struct FeatureFlags &ff);
#else
    extern void SciVis_renderTaskLauncher(void * __anon_parameter_0, void * __anon_parameter_1, const struct vec3ui *itemDims, struct Renderer * renderer, struct FrameBuffer * fb, struct Camera * camera, struct World * world, const uint32_t * taskIDs, const struct FeatureFlags *ff);
#endif // SciVis_renderTaskLauncher function declaraion
#if defined(__cplusplus) && (! defined(__ISPC_NO_EXTERN_C) || !__ISPC_NO_EXTERN_C )
} /* end extern C */
#endif // __cplusplus


#ifdef __cplusplus
} /* namespace */
#endif // __cplusplus
