#!/bin/bash

# Specify location of TBB
export TBBROOT=${PREFIX}

##############################################################################
# OpenImageDenoise
##############################################################################

cd ${SRC_DIR}/oidn

if [ ! -d build ]; then
    mkdir build
fi
cd build

echo "Configuring oidn..."
cmake \
    -G "${CMAKE_GENERATOR}" \
    ${CMAKE_ARGS} \
    -DISPC_EXECUTABLE="${SRC_DIR}/ispc/bin/ispc" \
    -DOIDN_APPS=OFF \
    -DTBB_ROOT=${TBBROOT} \
    ..

echo "Building oidn..."
cmake --build . --parallel ${CPU_COUNT}

echo "Installing oidn..."
make install

##############################################################################
# Embree
##############################################################################

cd ${SRC_DIR}/embree

# Patch the Embree CMake script to make it find Conda's version of the 'objdump' tool on Linux.
git apply ${RECIPE_DIR}/patches/0001-Use-OBJDUMP-environment-variable.patch

if [ ! -d build ]; then
    mkdir build
fi
cd build

echo "Configuring embree..."
cmake \
    -G "${CMAKE_GENERATOR}" \
    ${CMAKE_ARGS} \
    -DEMBREE_IGNORE_CMAKE_CXX_FLAGS=OFF \
    -DEMBREE_LIBRARY_NAME=embree_ovito \
    -DEMBREE_ISPC_EXECUTABLE="${SRC_DIR}/ispc/bin/ispc" \
    -DEMBREE_TUTORIALS=OFF \
    -DEMBREE_MAX_ISA=AVX2 \
    -DEMBREE_TBB_ROOT=${TBBROOT} \
    ..

echo "Building embree..."
cmake --build . --parallel ${CPU_COUNT}

echo "Installing embree..."
make install

##############################################################################
# rkcommon
##############################################################################

cd ${SRC_DIR}/rkcommon
if [ ! -d build ]; then
    mkdir build
fi
cd build

echo "Configuring rkcommon..."
cmake \
    -G "${CMAKE_GENERATOR}" \
    ${CMAKE_ARGS} \
    -DRKCOMMON_TBB_ROOT=${TBBROOT} \
    -DBUILD_TESTING=OFF \
    ..

echo "Building rkcommon..."
cmake --build . --parallel ${CPU_COUNT}

echo "Installing rkcommon..."
make install

##############################################################################
# OpenVKL
##############################################################################

cd ${SRC_DIR}/openvkl
if [ ! -d build ]; then
    mkdir build
fi
cd build

echo "Configuring openvkl..."
cmake \
    -G "${CMAKE_GENERATOR}" \
    ${CMAKE_ARGS} \
    -DISPC_EXECUTABLE="${SRC_DIR}/ispc/bin/ispc" \
    -DBUILD_TESTING=OFF \
    -DBUILD_EXAMPLES=OFF \
    -DRKCOMMON_TBB_ROOT=${TBBROOT} \
    ..

echo "Building openvkl..."
cmake --build . --parallel ${CPU_COUNT}

echo "Installing openvkl..."
make install

##############################################################################
# OSPRay
##############################################################################

cd ${SRC_DIR}/ospray

if [ ! -d build ]; then
    mkdir build
fi
cd build

echo "Configuring ospray..."
cmake \
    -G "${CMAKE_GENERATOR}" \
    ${CMAKE_ARGS} \
    -DISPC_EXECUTABLE="${SRC_DIR}/ispc/bin/ispc" \
    -DOSPRAY_APPS_TESTING=OFF \
    -DOSPRAY_ENABLE_APPS=OFF \
    -DOSPRAY_BUILD_ISA=AVX2 \
    -DOSPRAY_MODULE_DENOISER=ON \
    -DRKCOMMON_TBB_ROOT=${TBBROOT} \
    ..

echo "Building ospray..."
cmake --build . --parallel ${CPU_COUNT}

echo "Installing ospray..."
make install

echo "Cleaning up..."
# Remove stuff we don't want in the conda package.
rm -rfv $PREFIX/share/man/man3
rm -rfv $PREFIX/uninstall.command
rm -rfv $PREFIX/bin/rkcommon_test_suite
rm -rfv $PREFIX/share/doc/embree3/readme.pdf
rm -rfv $PREFIX/share/doc/OpenImageDenoise/readme.pdf

echo "Done"
