// Copyright 2021-2024 The Khronos Group
// SPDX-License-Identifier: Apache-2.0

// This file was generated by generate_headers.py
// Don't make changes to this directly


#pragma once

#include <anari/anari.h>
#include <math.h>
#include <stdint.h>

inline float anari_unit_clamp(float x) {
    if(x < -1.0f) {
        return -1.0f;
    } else if(x > 1.0f) {
        return 1.0f;
    } else {
        return x;
    }
}

inline int64_t anari_fixed_clamp(float x, int64_t max) {
    if(x <= -1.0f) {
        return -max;
    } else if(x >= 1.0f) {
        return max;
    } else {
        return (int64_t)(x*max);
    }
}

inline uint64_t anari_ufixed_clamp(float x, uint64_t max) {
    if(x <= 0.0f) {
        return 0u;
    } else if(x >= 1.0f) {
        return max;
    } else {
        return (uint64_t)(x*max);
    }
}

inline float anari_from_srgb(uint8_t x0) {
    float x = x0/(float)UINT8_MAX;
    if(x<=0.04045f) {
        return x*0.0773993808f;
    } else {
        return powf((x+0.055f)*0.94786729857f, 2.4f);
    }
}

inline uint8_t anari_to_srgb(float x) {
    if(x >= 1.0f) {
        return UINT8_MAX;
    } else if(x<=0.0f) {
        return 0u;
    } else if(x<=0.0031308f) {
        return (uint8_t)(x*12.92f*UINT8_MAX);
    } else {
        return (uint8_t)((powf(x*1.055f, 1.0f/2.4f)-0.055f)*UINT8_MAX);
    }
}


#ifdef __cplusplus

#include <utility>

namespace anari {

template<int type>
struct ANARITypeProperties { };

template<>
struct ANARITypeProperties<ANARI_UNKNOWN> {
    using base_type = int;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_UNKNOWN";
    static constexpr const char* type_name = "int";
    static constexpr const char* array_name = "int[1]";
    static constexpr const char* var_name = "varunknown";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_DATA_TYPE> {
    using base_type = int32_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_DATA_TYPE";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[1]";
    static constexpr const char* var_name = "vardata_type";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_STRING> {
    using base_type = const char*;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_STRING";
    static constexpr const char* type_name = "const char*";
    static constexpr const char* array_name = "const char*[1]";
    static constexpr const char* var_name = "varstring";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_VOID_POINTER> {
    using base_type = void*;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_VOID_POINTER";
    static constexpr const char* type_name = "void*";
    static constexpr const char* array_name = "void*[1]";
    static constexpr const char* var_name = "varvoid_pointer";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_BOOL> {
    using base_type = int8_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_BOOL";
    static constexpr const char* type_name = "int8_t";
    static constexpr const char* array_name = "int8_t[1]";
    static constexpr const char* var_name = "varbool";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_STRING_LIST> {
    using base_type = const char**;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_STRING_LIST";
    static constexpr const char* type_name = "const char**";
    static constexpr const char* array_name = "const char**[1]";
    static constexpr const char* var_name = "varstring_list";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_DATA_TYPE_LIST> {
    using base_type = ANARIDataType*;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_DATA_TYPE_LIST";
    static constexpr const char* type_name = "ANARIDataType*";
    static constexpr const char* array_name = "ANARIDataType*[1]";
    static constexpr const char* var_name = "vardata_type_list";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_PARAMETER_LIST> {
    using base_type = ANARIParameter*;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_PARAMETER_LIST";
    static constexpr const char* type_name = "ANARIParameter*";
    static constexpr const char* array_name = "ANARIParameter*[1]";
    static constexpr const char* var_name = "varparameter_list";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_FUNCTION_POINTER> {
    using base_type = void(*)(void);
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_FUNCTION_POINTER";
    static constexpr const char* type_name = "void(*)(void)";
    static constexpr const char* array_name = "void(*)(void)[1]";
    static constexpr const char* var_name = "varfunction_pointer";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_MEMORY_DELETER> {
    using base_type = ANARIMemoryDeleter;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_MEMORY_DELETER";
    static constexpr const char* type_name = "ANARIMemoryDeleter";
    static constexpr const char* array_name = "ANARIMemoryDeleter[1]";
    static constexpr const char* var_name = "varmemory_deleter";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_STATUS_CALLBACK> {
    using base_type = ANARIStatusCallback;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_STATUS_CALLBACK";
    static constexpr const char* type_name = "ANARIStatusCallback";
    static constexpr const char* array_name = "ANARIStatusCallback[1]";
    static constexpr const char* var_name = "varstatus_callback";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_LIBRARY> {
    using base_type = ANARILibrary;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_LIBRARY";
    static constexpr const char* type_name = "ANARILibrary";
    static constexpr const char* array_name = "ANARILibrary[1]";
    static constexpr const char* var_name = "varlibrary";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_DEVICE> {
    using base_type = ANARIDevice;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_DEVICE";
    static constexpr const char* type_name = "ANARIDevice";
    static constexpr const char* array_name = "ANARIDevice[1]";
    static constexpr const char* var_name = "vardevice";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_OBJECT> {
    using base_type = ANARIObject;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_OBJECT";
    static constexpr const char* type_name = "ANARIObject";
    static constexpr const char* array_name = "ANARIObject[1]";
    static constexpr const char* var_name = "varobject";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_ARRAY> {
    using base_type = ANARIArray;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_ARRAY";
    static constexpr const char* type_name = "ANARIArray";
    static constexpr const char* array_name = "ANARIArray[1]";
    static constexpr const char* var_name = "vararray";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_ARRAY1D> {
    using base_type = ANARIArray1D;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_ARRAY1D";
    static constexpr const char* type_name = "ANARIArray1D";
    static constexpr const char* array_name = "ANARIArray1D[1]";
    static constexpr const char* var_name = "vararray1d";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_ARRAY2D> {
    using base_type = ANARIArray2D;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_ARRAY2D";
    static constexpr const char* type_name = "ANARIArray2D";
    static constexpr const char* array_name = "ANARIArray2D[1]";
    static constexpr const char* var_name = "vararray2d";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_ARRAY3D> {
    using base_type = ANARIArray3D;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_ARRAY3D";
    static constexpr const char* type_name = "ANARIArray3D";
    static constexpr const char* array_name = "ANARIArray3D[1]";
    static constexpr const char* var_name = "vararray3d";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_CAMERA> {
    using base_type = ANARICamera;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_CAMERA";
    static constexpr const char* type_name = "ANARICamera";
    static constexpr const char* array_name = "ANARICamera[1]";
    static constexpr const char* var_name = "varcamera";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_FRAME> {
    using base_type = ANARIFrame;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_FRAME";
    static constexpr const char* type_name = "ANARIFrame";
    static constexpr const char* array_name = "ANARIFrame[1]";
    static constexpr const char* var_name = "varframe";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_GEOMETRY> {
    using base_type = ANARIGeometry;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_GEOMETRY";
    static constexpr const char* type_name = "ANARIGeometry";
    static constexpr const char* array_name = "ANARIGeometry[1]";
    static constexpr const char* var_name = "vargeometry";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_GROUP> {
    using base_type = ANARIGroup;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_GROUP";
    static constexpr const char* type_name = "ANARIGroup";
    static constexpr const char* array_name = "ANARIGroup[1]";
    static constexpr const char* var_name = "vargroup";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_INSTANCE> {
    using base_type = ANARIInstance;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_INSTANCE";
    static constexpr const char* type_name = "ANARIInstance";
    static constexpr const char* array_name = "ANARIInstance[1]";
    static constexpr const char* var_name = "varinstance";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_LIGHT> {
    using base_type = ANARILight;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_LIGHT";
    static constexpr const char* type_name = "ANARILight";
    static constexpr const char* array_name = "ANARILight[1]";
    static constexpr const char* var_name = "varlight";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_MATERIAL> {
    using base_type = ANARIMaterial;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_MATERIAL";
    static constexpr const char* type_name = "ANARIMaterial";
    static constexpr const char* array_name = "ANARIMaterial[1]";
    static constexpr const char* var_name = "varmaterial";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_RENDERER> {
    using base_type = ANARIRenderer;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_RENDERER";
    static constexpr const char* type_name = "ANARIRenderer";
    static constexpr const char* array_name = "ANARIRenderer[1]";
    static constexpr const char* var_name = "varrenderer";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_SURFACE> {
    using base_type = ANARISurface;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_SURFACE";
    static constexpr const char* type_name = "ANARISurface";
    static constexpr const char* array_name = "ANARISurface[1]";
    static constexpr const char* var_name = "varsurface";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_SAMPLER> {
    using base_type = ANARISampler;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_SAMPLER";
    static constexpr const char* type_name = "ANARISampler";
    static constexpr const char* array_name = "ANARISampler[1]";
    static constexpr const char* var_name = "varsampler";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_SPATIAL_FIELD> {
    using base_type = ANARISpatialField;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_SPATIAL_FIELD";
    static constexpr const char* type_name = "ANARISpatialField";
    static constexpr const char* array_name = "ANARISpatialField[1]";
    static constexpr const char* var_name = "varspatial_field";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_VOLUME> {
    using base_type = ANARIVolume;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_VOLUME";
    static constexpr const char* type_name = "ANARIVolume";
    static constexpr const char* array_name = "ANARIVolume[1]";
    static constexpr const char* var_name = "varvolume";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_WORLD> {
    using base_type = ANARIWorld;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_WORLD";
    static constexpr const char* type_name = "ANARIWorld";
    static constexpr const char* array_name = "ANARIWorld[1]";
    static constexpr const char* var_name = "varworld";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};
template<>
struct ANARITypeProperties<ANARI_INT8> {
    using base_type = int8_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_INT8";
    static constexpr const char* type_name = "int8_t";
    static constexpr const char* array_name = "int8_t[1]";
    static constexpr const char* var_name = "varint8";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT8_VEC2> {
    using base_type = int8_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_INT8_VEC2";
    static constexpr const char* type_name = "int8_t";
    static constexpr const char* array_name = "int8_t[2]";
    static constexpr const char* var_name = "varint8_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT8_VEC3> {
    using base_type = int8_t;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_INT8_VEC3";
    static constexpr const char* type_name = "int8_t";
    static constexpr const char* array_name = "int8_t[3]";
    static constexpr const char* var_name = "varint8_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT8_VEC4> {
    using base_type = int8_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_INT8_VEC4";
    static constexpr const char* type_name = "int8_t";
    static constexpr const char* array_name = "int8_t[4]";
    static constexpr const char* var_name = "varint8_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT8> {
    using base_type = uint8_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_UINT8";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[1]";
    static constexpr const char* var_name = "varuint8";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT8_VEC2> {
    using base_type = uint8_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_UINT8_VEC2";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[2]";
    static constexpr const char* var_name = "varuint8_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT8_VEC3> {
    using base_type = uint8_t;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_UINT8_VEC3";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[3]";
    static constexpr const char* var_name = "varuint8_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT8_VEC4> {
    using base_type = uint8_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_UINT8_VEC4";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[4]";
    static constexpr const char* var_name = "varuint8_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT16> {
    using base_type = int16_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_INT16";
    static constexpr const char* type_name = "int16_t";
    static constexpr const char* array_name = "int16_t[1]";
    static constexpr const char* var_name = "varint16";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT16_VEC2> {
    using base_type = int16_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_INT16_VEC2";
    static constexpr const char* type_name = "int16_t";
    static constexpr const char* array_name = "int16_t[2]";
    static constexpr const char* var_name = "varint16_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT16_VEC3> {
    using base_type = int16_t;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_INT16_VEC3";
    static constexpr const char* type_name = "int16_t";
    static constexpr const char* array_name = "int16_t[3]";
    static constexpr const char* var_name = "varint16_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT16_VEC4> {
    using base_type = int16_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_INT16_VEC4";
    static constexpr const char* type_name = "int16_t";
    static constexpr const char* array_name = "int16_t[4]";
    static constexpr const char* var_name = "varint16_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT16> {
    using base_type = uint16_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_UINT16";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[1]";
    static constexpr const char* var_name = "varuint16";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT16_VEC2> {
    using base_type = uint16_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_UINT16_VEC2";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[2]";
    static constexpr const char* var_name = "varuint16_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT16_VEC3> {
    using base_type = uint16_t;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_UINT16_VEC3";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[3]";
    static constexpr const char* var_name = "varuint16_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT16_VEC4> {
    using base_type = uint16_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_UINT16_VEC4";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[4]";
    static constexpr const char* var_name = "varuint16_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT32> {
    using base_type = int32_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_INT32";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[1]";
    static constexpr const char* var_name = "varint32";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT32_VEC2> {
    using base_type = int32_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_INT32_VEC2";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[2]";
    static constexpr const char* var_name = "varint32_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT32_VEC3> {
    using base_type = int32_t;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_INT32_VEC3";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[3]";
    static constexpr const char* var_name = "varint32_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT32_VEC4> {
    using base_type = int32_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_INT32_VEC4";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[4]";
    static constexpr const char* var_name = "varint32_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT32> {
    using base_type = uint32_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_UINT32";
    static constexpr const char* type_name = "uint32_t";
    static constexpr const char* array_name = "uint32_t[1]";
    static constexpr const char* var_name = "varuint32";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT32_VEC2> {
    using base_type = uint32_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_UINT32_VEC2";
    static constexpr const char* type_name = "uint32_t";
    static constexpr const char* array_name = "uint32_t[2]";
    static constexpr const char* var_name = "varuint32_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT32_VEC3> {
    using base_type = uint32_t;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_UINT32_VEC3";
    static constexpr const char* type_name = "uint32_t";
    static constexpr const char* array_name = "uint32_t[3]";
    static constexpr const char* var_name = "varuint32_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT32_VEC4> {
    using base_type = uint32_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_UINT32_VEC4";
    static constexpr const char* type_name = "uint32_t";
    static constexpr const char* array_name = "uint32_t[4]";
    static constexpr const char* var_name = "varuint32_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT64> {
    using base_type = int64_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_INT64";
    static constexpr const char* type_name = "int64_t";
    static constexpr const char* array_name = "int64_t[1]";
    static constexpr const char* var_name = "varint64";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT64_VEC2> {
    using base_type = int64_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_INT64_VEC2";
    static constexpr const char* type_name = "int64_t";
    static constexpr const char* array_name = "int64_t[2]";
    static constexpr const char* var_name = "varint64_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT64_VEC3> {
    using base_type = int64_t;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_INT64_VEC3";
    static constexpr const char* type_name = "int64_t";
    static constexpr const char* array_name = "int64_t[3]";
    static constexpr const char* var_name = "varint64_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT64_VEC4> {
    using base_type = int64_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_INT64_VEC4";
    static constexpr const char* type_name = "int64_t";
    static constexpr const char* array_name = "int64_t[4]";
    static constexpr const char* var_name = "varint64_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT64> {
    using base_type = uint64_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_UINT64";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[1]";
    static constexpr const char* var_name = "varuint64";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT64_VEC2> {
    using base_type = uint64_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_UINT64_VEC2";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[2]";
    static constexpr const char* var_name = "varuint64_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT64_VEC3> {
    using base_type = uint64_t;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_UINT64_VEC3";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[3]";
    static constexpr const char* var_name = "varuint64_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT64_VEC4> {
    using base_type = uint64_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_UINT64_VEC4";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[4]";
    static constexpr const char* var_name = "varuint64_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED8> {
    using base_type = int8_t;
    static const int components = 1;
    static const bool normalized = true;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_FIXED8";
    static constexpr const char* type_name = "int8_t";
    static constexpr const char* array_name = "int8_t[1]";
    static constexpr const char* var_name = "varfixed8";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT8_MAX);
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT8_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED8_VEC2> {
    using base_type = int8_t;
    static const int components = 2;
    static const bool normalized = true;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_FIXED8_VEC2";
    static constexpr const char* type_name = "int8_t";
    static constexpr const char* array_name = "int8_t[2]";
    static constexpr const char* var_name = "varfixed8_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT8_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT8_MAX);
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT8_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT8_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED8_VEC3> {
    using base_type = int8_t;
    static const int components = 3;
    static const bool normalized = true;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_FIXED8_VEC3";
    static constexpr const char* type_name = "int8_t";
    static constexpr const char* array_name = "int8_t[3]";
    static constexpr const char* var_name = "varfixed8_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT8_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT8_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)INT8_MAX);
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT8_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT8_MAX);
        dst[2] = (base_type)anari_fixed_clamp(src[2], INT8_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED8_VEC4> {
    using base_type = int8_t;
    static const int components = 4;
    static const bool normalized = true;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FIXED8_VEC4";
    static constexpr const char* type_name = "int8_t";
    static constexpr const char* array_name = "int8_t[4]";
    static constexpr const char* var_name = "varfixed8_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT8_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT8_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)INT8_MAX);
        dst[3] = anari_unit_clamp((float)src[3]/(float)INT8_MAX);
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT8_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT8_MAX);
        dst[2] = (base_type)anari_fixed_clamp(src[2], INT8_MAX);
        dst[3] = (base_type)anari_fixed_clamp(src[3], INT8_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED8> {
    using base_type = uint8_t;
    static const int components = 1;
    static const bool normalized = true;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_UFIXED8";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[1]";
    static constexpr const char* var_name = "varufixed8";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT8_MAX);
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT8_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED8_VEC2> {
    using base_type = uint8_t;
    static const int components = 2;
    static const bool normalized = true;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_UFIXED8_VEC2";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[2]";
    static constexpr const char* var_name = "varufixed8_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT8_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT8_MAX);
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT8_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT8_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED8_VEC3> {
    using base_type = uint8_t;
    static const int components = 3;
    static const bool normalized = true;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_UFIXED8_VEC3";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[3]";
    static constexpr const char* var_name = "varufixed8_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT8_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT8_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)UINT8_MAX);
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT8_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT8_MAX);
        dst[2] = (base_type)anari_ufixed_clamp(src[2], UINT8_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED8_VEC4> {
    using base_type = uint8_t;
    static const int components = 4;
    static const bool normalized = true;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_UFIXED8_VEC4";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[4]";
    static constexpr const char* var_name = "varufixed8_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT8_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT8_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)UINT8_MAX);
        dst[3] = anari_unit_clamp((float)src[3]/(float)UINT8_MAX);
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT8_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT8_MAX);
        dst[2] = (base_type)anari_ufixed_clamp(src[2], UINT8_MAX);
        dst[3] = (base_type)anari_ufixed_clamp(src[3], UINT8_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED16> {
    using base_type = int16_t;
    static const int components = 1;
    static const bool normalized = true;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_FIXED16";
    static constexpr const char* type_name = "int16_t";
    static constexpr const char* array_name = "int16_t[1]";
    static constexpr const char* var_name = "varfixed16";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT16_MAX);
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT16_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED16_VEC2> {
    using base_type = int16_t;
    static const int components = 2;
    static const bool normalized = true;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_FIXED16_VEC2";
    static constexpr const char* type_name = "int16_t";
    static constexpr const char* array_name = "int16_t[2]";
    static constexpr const char* var_name = "varfixed16_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT16_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT16_MAX);
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT16_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT16_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED16_VEC3> {
    using base_type = int16_t;
    static const int components = 3;
    static const bool normalized = true;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_FIXED16_VEC3";
    static constexpr const char* type_name = "int16_t";
    static constexpr const char* array_name = "int16_t[3]";
    static constexpr const char* var_name = "varfixed16_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT16_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT16_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)INT16_MAX);
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT16_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT16_MAX);
        dst[2] = (base_type)anari_fixed_clamp(src[2], INT16_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED16_VEC4> {
    using base_type = int16_t;
    static const int components = 4;
    static const bool normalized = true;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FIXED16_VEC4";
    static constexpr const char* type_name = "int16_t";
    static constexpr const char* array_name = "int16_t[4]";
    static constexpr const char* var_name = "varfixed16_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT16_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT16_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)INT16_MAX);
        dst[3] = anari_unit_clamp((float)src[3]/(float)INT16_MAX);
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT16_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT16_MAX);
        dst[2] = (base_type)anari_fixed_clamp(src[2], INT16_MAX);
        dst[3] = (base_type)anari_fixed_clamp(src[3], INT16_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED16> {
    using base_type = uint16_t;
    static const int components = 1;
    static const bool normalized = true;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_UFIXED16";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[1]";
    static constexpr const char* var_name = "varufixed16";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT16_MAX);
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT16_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED16_VEC2> {
    using base_type = uint16_t;
    static const int components = 2;
    static const bool normalized = true;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_UFIXED16_VEC2";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[2]";
    static constexpr const char* var_name = "varufixed16_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT16_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT16_MAX);
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT16_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT16_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED16_VEC3> {
    using base_type = uint16_t;
    static const int components = 3;
    static const bool normalized = true;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_UFIXED16_VEC3";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[3]";
    static constexpr const char* var_name = "varufixed16_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT16_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT16_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)UINT16_MAX);
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT16_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT16_MAX);
        dst[2] = (base_type)anari_ufixed_clamp(src[2], UINT16_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED16_VEC4> {
    using base_type = uint16_t;
    static const int components = 4;
    static const bool normalized = true;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_UFIXED16_VEC4";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[4]";
    static constexpr const char* var_name = "varufixed16_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT16_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT16_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)UINT16_MAX);
        dst[3] = anari_unit_clamp((float)src[3]/(float)UINT16_MAX);
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT16_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT16_MAX);
        dst[2] = (base_type)anari_ufixed_clamp(src[2], UINT16_MAX);
        dst[3] = (base_type)anari_ufixed_clamp(src[3], UINT16_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED32> {
    using base_type = int32_t;
    static const int components = 1;
    static const bool normalized = true;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_FIXED32";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[1]";
    static constexpr const char* var_name = "varfixed32";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT32_MAX);
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT32_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED32_VEC2> {
    using base_type = int32_t;
    static const int components = 2;
    static const bool normalized = true;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_FIXED32_VEC2";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[2]";
    static constexpr const char* var_name = "varfixed32_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT32_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT32_MAX);
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT32_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT32_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED32_VEC3> {
    using base_type = int32_t;
    static const int components = 3;
    static const bool normalized = true;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_FIXED32_VEC3";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[3]";
    static constexpr const char* var_name = "varfixed32_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT32_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT32_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)INT32_MAX);
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT32_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT32_MAX);
        dst[2] = (base_type)anari_fixed_clamp(src[2], INT32_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED32_VEC4> {
    using base_type = int32_t;
    static const int components = 4;
    static const bool normalized = true;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FIXED32_VEC4";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[4]";
    static constexpr const char* var_name = "varfixed32_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT32_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT32_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)INT32_MAX);
        dst[3] = anari_unit_clamp((float)src[3]/(float)INT32_MAX);
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT32_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT32_MAX);
        dst[2] = (base_type)anari_fixed_clamp(src[2], INT32_MAX);
        dst[3] = (base_type)anari_fixed_clamp(src[3], INT32_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED32> {
    using base_type = uint32_t;
    static const int components = 1;
    static const bool normalized = true;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_UFIXED32";
    static constexpr const char* type_name = "uint32_t";
    static constexpr const char* array_name = "uint32_t[1]";
    static constexpr const char* var_name = "varufixed32";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT32_MAX);
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT32_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED32_VEC2> {
    using base_type = uint32_t;
    static const int components = 2;
    static const bool normalized = true;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_UFIXED32_VEC2";
    static constexpr const char* type_name = "uint32_t";
    static constexpr const char* array_name = "uint32_t[2]";
    static constexpr const char* var_name = "varufixed32_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT32_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT32_MAX);
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT32_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT32_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED32_VEC3> {
    using base_type = uint32_t;
    static const int components = 3;
    static const bool normalized = true;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_UFIXED32_VEC3";
    static constexpr const char* type_name = "uint32_t";
    static constexpr const char* array_name = "uint32_t[3]";
    static constexpr const char* var_name = "varufixed32_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT32_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT32_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)UINT32_MAX);
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT32_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT32_MAX);
        dst[2] = (base_type)anari_ufixed_clamp(src[2], UINT32_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED32_VEC4> {
    using base_type = uint32_t;
    static const int components = 4;
    static const bool normalized = true;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_UFIXED32_VEC4";
    static constexpr const char* type_name = "uint32_t";
    static constexpr const char* array_name = "uint32_t[4]";
    static constexpr const char* var_name = "varufixed32_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT32_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT32_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)UINT32_MAX);
        dst[3] = anari_unit_clamp((float)src[3]/(float)UINT32_MAX);
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT32_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT32_MAX);
        dst[2] = (base_type)anari_ufixed_clamp(src[2], UINT32_MAX);
        dst[3] = (base_type)anari_ufixed_clamp(src[3], UINT32_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED64> {
    using base_type = int64_t;
    static const int components = 1;
    static const bool normalized = true;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_FIXED64";
    static constexpr const char* type_name = "int64_t";
    static constexpr const char* array_name = "int64_t[1]";
    static constexpr const char* var_name = "varfixed64";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT64_MAX);
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT64_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED64_VEC2> {
    using base_type = int64_t;
    static const int components = 2;
    static const bool normalized = true;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_FIXED64_VEC2";
    static constexpr const char* type_name = "int64_t";
    static constexpr const char* array_name = "int64_t[2]";
    static constexpr const char* var_name = "varfixed64_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT64_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT64_MAX);
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT64_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT64_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED64_VEC3> {
    using base_type = int64_t;
    static const int components = 3;
    static const bool normalized = true;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_FIXED64_VEC3";
    static constexpr const char* type_name = "int64_t";
    static constexpr const char* array_name = "int64_t[3]";
    static constexpr const char* var_name = "varfixed64_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT64_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT64_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)INT64_MAX);
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT64_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT64_MAX);
        dst[2] = (base_type)anari_fixed_clamp(src[2], INT64_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FIXED64_VEC4> {
    using base_type = int64_t;
    static const int components = 4;
    static const bool normalized = true;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FIXED64_VEC4";
    static constexpr const char* type_name = "int64_t";
    static constexpr const char* array_name = "int64_t[4]";
    static constexpr const char* var_name = "varfixed64_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)INT64_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)INT64_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)INT64_MAX);
        dst[3] = anari_unit_clamp((float)src[3]/(float)INT64_MAX);
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_fixed_clamp(src[0], INT64_MAX);
        dst[1] = (base_type)anari_fixed_clamp(src[1], INT64_MAX);
        dst[2] = (base_type)anari_fixed_clamp(src[2], INT64_MAX);
        dst[3] = (base_type)anari_fixed_clamp(src[3], INT64_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED64> {
    using base_type = uint64_t;
    static const int components = 1;
    static const bool normalized = true;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_UFIXED64";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[1]";
    static constexpr const char* var_name = "varufixed64";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT64_MAX);
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT64_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED64_VEC2> {
    using base_type = uint64_t;
    static const int components = 2;
    static const bool normalized = true;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_UFIXED64_VEC2";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[2]";
    static constexpr const char* var_name = "varufixed64_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT64_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT64_MAX);
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT64_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT64_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED64_VEC3> {
    using base_type = uint64_t;
    static const int components = 3;
    static const bool normalized = true;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_UFIXED64_VEC3";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[3]";
    static constexpr const char* var_name = "varufixed64_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT64_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT64_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)UINT64_MAX);
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT64_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT64_MAX);
        dst[2] = (base_type)anari_ufixed_clamp(src[2], UINT64_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED64_VEC4> {
    using base_type = uint64_t;
    static const int components = 4;
    static const bool normalized = true;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_UFIXED64_VEC4";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[4]";
    static constexpr const char* var_name = "varufixed64_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_unit_clamp((float)src[0]/(float)UINT64_MAX);
        dst[1] = anari_unit_clamp((float)src[1]/(float)UINT64_MAX);
        dst[2] = anari_unit_clamp((float)src[2]/(float)UINT64_MAX);
        dst[3] = anari_unit_clamp((float)src[3]/(float)UINT64_MAX);
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)anari_ufixed_clamp(src[0], UINT64_MAX);
        dst[1] = (base_type)anari_ufixed_clamp(src[1], UINT64_MAX);
        dst[2] = (base_type)anari_ufixed_clamp(src[2], UINT64_MAX);
        dst[3] = (base_type)anari_ufixed_clamp(src[3], UINT64_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT16> {
    using base_type = uint16_t;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_FLOAT16";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[1]";
    static constexpr const char* var_name = "varfloat16";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT16_VEC2> {
    using base_type = uint16_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_FLOAT16_VEC2";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[2]";
    static constexpr const char* var_name = "varfloat16_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT16_VEC3> {
    using base_type = uint16_t;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_FLOAT16_VEC3";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[3]";
    static constexpr const char* var_name = "varfloat16_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT16_VEC4> {
    using base_type = uint16_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FLOAT16_VEC4";
    static constexpr const char* type_name = "uint16_t";
    static constexpr const char* array_name = "uint16_t[4]";
    static constexpr const char* var_name = "varfloat16_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32> {
    using base_type = float;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_FLOAT32";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[1]";
    static constexpr const char* var_name = "varfloat32";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_VEC2> {
    using base_type = float;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_FLOAT32_VEC2";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[2]";
    static constexpr const char* var_name = "varfloat32_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_VEC3> {
    using base_type = float;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_FLOAT32_VEC3";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[3]";
    static constexpr const char* var_name = "varfloat32_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_VEC4> {
    using base_type = float;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FLOAT32_VEC4";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[4]";
    static constexpr const char* var_name = "varfloat32_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT64> {
    using base_type = double;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_FLOAT64";
    static constexpr const char* type_name = "double";
    static constexpr const char* array_name = "double[1]";
    static constexpr const char* var_name = "varfloat64";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT64_VEC2> {
    using base_type = double;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_FLOAT64_VEC2";
    static constexpr const char* type_name = "double";
    static constexpr const char* array_name = "double[2]";
    static constexpr const char* var_name = "varfloat64_vec2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT64_VEC3> {
    using base_type = double;
    static const int components = 3;
    static const bool normalized = false;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_FLOAT64_VEC3";
    static constexpr const char* type_name = "double";
    static constexpr const char* array_name = "double[3]";
    static constexpr const char* var_name = "varfloat64_vec3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT64_VEC4> {
    using base_type = double;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FLOAT64_VEC4";
    static constexpr const char* type_name = "double";
    static constexpr const char* array_name = "double[4]";
    static constexpr const char* var_name = "varfloat64_vec4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED8_RGBA_SRGB> {
    using base_type = uint8_t;
    static const int components = 4;
    static const bool normalized = true;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_UFIXED8_RGBA_SRGB";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[4]";
    static constexpr const char* var_name = "varufixed8_rgba_srgb";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_from_srgb(src[0]);
        dst[1] = anari_from_srgb(src[1]);
        dst[2] = anari_from_srgb(src[2]);
        dst[3] = anari_unit_clamp(src[3]);
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = anari_to_srgb(src[0]);
        dst[1] = anari_to_srgb(src[1]);
        dst[2] = anari_to_srgb(src[2]);
        dst[3] = (base_type)anari_ufixed_clamp(float(src[3]), UINT8_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED8_RGB_SRGB> {
    using base_type = uint8_t;
    static const int components = 3;
    static const bool normalized = true;
    using array_type = base_type[3];
    static constexpr const char* enum_name = "ANARI_UFIXED8_RGB_SRGB";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[3]";
    static constexpr const char* var_name = "varufixed8_rgb_srgb";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_from_srgb(src[0]);
        dst[1] = anari_from_srgb(src[1]);
        dst[2] = anari_from_srgb(src[2]);
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = anari_to_srgb(src[0]);
        dst[1] = anari_to_srgb(src[1]);
        dst[2] = anari_to_srgb(src[2]);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED8_RA_SRGB> {
    using base_type = uint8_t;
    static const int components = 2;
    static const bool normalized = true;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_UFIXED8_RA_SRGB";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[2]";
    static constexpr const char* var_name = "varufixed8_ra_srgb";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_from_srgb(src[0]);
        dst[1] = 0;
        dst[2] = 0;
        dst[3] = anari_unit_clamp(src[1]/(float)UINT8_MAX);
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = anari_to_srgb(src[0]);
        dst[1] = (base_type)anari_ufixed_clamp(src[3], UINT8_MAX);
    }
};
template<>
struct ANARITypeProperties<ANARI_UFIXED8_R_SRGB> {
    using base_type = uint8_t;
    static const int components = 1;
    static const bool normalized = true;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_UFIXED8_R_SRGB";
    static constexpr const char* type_name = "uint8_t";
    static constexpr const char* array_name = "uint8_t[1]";
    static constexpr const char* var_name = "varufixed8_r_srgb";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = anari_from_srgb(src[0]);
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = anari_to_srgb(src[0]);
    }
};
template<>
struct ANARITypeProperties<ANARI_INT32_BOX1> {
    using base_type = int32_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_INT32_BOX1";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[2]";
    static constexpr const char* var_name = "varint32_box1";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT32_BOX2> {
    using base_type = int32_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_INT32_BOX2";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[4]";
    static constexpr const char* var_name = "varint32_box2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT32_BOX3> {
    using base_type = int32_t;
    static const int components = 6;
    static const bool normalized = false;
    using array_type = base_type[6];
    static constexpr const char* enum_name = "ANARI_INT32_BOX3";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[6]";
    static constexpr const char* var_name = "varint32_box3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_INT32_BOX4> {
    using base_type = int32_t;
    static const int components = 8;
    static const bool normalized = false;
    using array_type = base_type[8];
    static constexpr const char* enum_name = "ANARI_INT32_BOX4";
    static constexpr const char* type_name = "int32_t";
    static constexpr const char* array_name = "int32_t[8]";
    static constexpr const char* var_name = "varint32_box4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_BOX1> {
    using base_type = float;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_FLOAT32_BOX1";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[2]";
    static constexpr const char* var_name = "varfloat32_box1";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_BOX2> {
    using base_type = float;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FLOAT32_BOX2";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[4]";
    static constexpr const char* var_name = "varfloat32_box2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_BOX3> {
    using base_type = float;
    static const int components = 6;
    static const bool normalized = false;
    using array_type = base_type[6];
    static constexpr const char* enum_name = "ANARI_FLOAT32_BOX3";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[6]";
    static constexpr const char* var_name = "varfloat32_box3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_BOX4> {
    using base_type = float;
    static const int components = 8;
    static const bool normalized = false;
    using array_type = base_type[8];
    static constexpr const char* enum_name = "ANARI_FLOAT32_BOX4";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[8]";
    static constexpr const char* var_name = "varfloat32_box4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT64_BOX1> {
    using base_type = double;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_FLOAT64_BOX1";
    static constexpr const char* type_name = "double";
    static constexpr const char* array_name = "double[2]";
    static constexpr const char* var_name = "varfloat64_box1";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT64_BOX2> {
    using base_type = double;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FLOAT64_BOX2";
    static constexpr const char* type_name = "double";
    static constexpr const char* array_name = "double[4]";
    static constexpr const char* var_name = "varfloat64_box2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT64_BOX3> {
    using base_type = double;
    static const int components = 6;
    static const bool normalized = false;
    using array_type = base_type[6];
    static constexpr const char* enum_name = "ANARI_FLOAT64_BOX3";
    static constexpr const char* type_name = "double";
    static constexpr const char* array_name = "double[6]";
    static constexpr const char* var_name = "varfloat64_box3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT64_BOX4> {
    using base_type = double;
    static const int components = 8;
    static const bool normalized = false;
    using array_type = base_type[8];
    static constexpr const char* enum_name = "ANARI_FLOAT64_BOX4";
    static constexpr const char* type_name = "double";
    static constexpr const char* array_name = "double[8]";
    static constexpr const char* var_name = "varfloat64_box4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT64_REGION1> {
    using base_type = uint64_t;
    static const int components = 2;
    static const bool normalized = false;
    using array_type = base_type[2];
    static constexpr const char* enum_name = "ANARI_UINT64_REGION1";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[2]";
    static constexpr const char* var_name = "varuint64_region1";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = 0.0f;
        dst[3] = 1.0f;
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT64_REGION2> {
    using base_type = uint64_t;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_UINT64_REGION2";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[4]";
    static constexpr const char* var_name = "varuint64_region2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT64_REGION3> {
    using base_type = uint64_t;
    static const int components = 6;
    static const bool normalized = false;
    using array_type = base_type[6];
    static constexpr const char* enum_name = "ANARI_UINT64_REGION3";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[6]";
    static constexpr const char* var_name = "varuint64_region3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_UINT64_REGION4> {
    using base_type = uint64_t;
    static const int components = 8;
    static const bool normalized = false;
    using array_type = base_type[8];
    static constexpr const char* enum_name = "ANARI_UINT64_REGION4";
    static constexpr const char* type_name = "uint64_t";
    static constexpr const char* array_name = "uint64_t[8]";
    static constexpr const char* var_name = "varuint64_region4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_MAT2> {
    using base_type = float;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FLOAT32_MAT2";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[4]";
    static constexpr const char* var_name = "varfloat32_mat2";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_MAT3> {
    using base_type = float;
    static const int components = 9;
    static const bool normalized = false;
    using array_type = base_type[9];
    static constexpr const char* enum_name = "ANARI_FLOAT32_MAT3";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[9]";
    static constexpr const char* var_name = "varfloat32_mat3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_MAT4> {
    using base_type = float;
    static const int components = 16;
    static const bool normalized = false;
    using array_type = base_type[16];
    static constexpr const char* enum_name = "ANARI_FLOAT32_MAT4";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[16]";
    static constexpr const char* var_name = "varfloat32_mat4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_MAT2x3> {
    using base_type = float;
    static const int components = 6;
    static const bool normalized = false;
    using array_type = base_type[6];
    static constexpr const char* enum_name = "ANARI_FLOAT32_MAT2x3";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[6]";
    static constexpr const char* var_name = "varfloat32_mat2x3";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_MAT3x4> {
    using base_type = float;
    static const int components = 12;
    static const bool normalized = false;
    using array_type = base_type[12];
    static constexpr const char* enum_name = "ANARI_FLOAT32_MAT3x4";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[12]";
    static constexpr const char* var_name = "varfloat32_mat3x4";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FLOAT32_QUAT_IJKW> {
    using base_type = float;
    static const int components = 4;
    static const bool normalized = false;
    using array_type = base_type[4];
    static constexpr const char* enum_name = "ANARI_FLOAT32_QUAT_IJKW";
    static constexpr const char* type_name = "float";
    static constexpr const char* array_name = "float[4]";
    static constexpr const char* var_name = "varfloat32_quat_ijkw";
    static void toFloat4(float *dst, const base_type *src) {
        dst[0] = (float)src[0];
        dst[1] = (float)src[1];
        dst[2] = (float)src[2];
        dst[3] = (float)src[3];
    }
    static void fromFloat4(base_type *dst, const float *src) {
        dst[0] = (base_type)src[0];
        dst[1] = (base_type)src[1];
        dst[2] = (base_type)src[2];
        dst[3] = (base_type)src[3];
    }
};
template<>
struct ANARITypeProperties<ANARI_FRAME_COMPLETION_CALLBACK> {
    using base_type = ANARIFrameCompletionCallback;
    static const int components = 1;
    static const bool normalized = false;
    using array_type = base_type[1];
    static constexpr const char* enum_name = "ANARI_FRAME_COMPLETION_CALLBACK";
    static constexpr const char* type_name = "ANARIFrameCompletionCallback";
    static constexpr const char* array_name = "ANARIFrameCompletionCallback[1]";
    static constexpr const char* var_name = "varframe_completion_callback";
    static void fromFloat4(base_type *dst, const float *src) { }
    static void toFloat4(float *dst, const base_type *src) { }
};

template <typename R, template<int> class F, typename... Args>
R anariTypeInvoke(ANARIDataType type, Args&&... args) {
    switch (type) {
        case 0: return F<0>()(std::forward<Args>(args)...);
        case 100: return F<100>()(std::forward<Args>(args)...);
        case 101: return F<101>()(std::forward<Args>(args)...);
        case 102: return F<102>()(std::forward<Args>(args)...);
        case 103: return F<103>()(std::forward<Args>(args)...);
        case 150: return F<150>()(std::forward<Args>(args)...);
        case 151: return F<151>()(std::forward<Args>(args)...);
        case 152: return F<152>()(std::forward<Args>(args)...);
        case 200: return F<200>()(std::forward<Args>(args)...);
        case 201: return F<201>()(std::forward<Args>(args)...);
        case 202: return F<202>()(std::forward<Args>(args)...);
        case 500: return F<500>()(std::forward<Args>(args)...);
        case 501: return F<501>()(std::forward<Args>(args)...);
        case 502: return F<502>()(std::forward<Args>(args)...);
        case 503: return F<503>()(std::forward<Args>(args)...);
        case 504: return F<504>()(std::forward<Args>(args)...);
        case 505: return F<505>()(std::forward<Args>(args)...);
        case 506: return F<506>()(std::forward<Args>(args)...);
        case 507: return F<507>()(std::forward<Args>(args)...);
        case 508: return F<508>()(std::forward<Args>(args)...);
        case 509: return F<509>()(std::forward<Args>(args)...);
        case 510: return F<510>()(std::forward<Args>(args)...);
        case 511: return F<511>()(std::forward<Args>(args)...);
        case 512: return F<512>()(std::forward<Args>(args)...);
        case 513: return F<513>()(std::forward<Args>(args)...);
        case 514: return F<514>()(std::forward<Args>(args)...);
        case 515: return F<515>()(std::forward<Args>(args)...);
        case 516: return F<516>()(std::forward<Args>(args)...);
        case 517: return F<517>()(std::forward<Args>(args)...);
        case 518: return F<518>()(std::forward<Args>(args)...);
        case 519: return F<519>()(std::forward<Args>(args)...);
        case 1000: return F<1000>()(std::forward<Args>(args)...);
        case 1001: return F<1001>()(std::forward<Args>(args)...);
        case 1002: return F<1002>()(std::forward<Args>(args)...);
        case 1003: return F<1003>()(std::forward<Args>(args)...);
        case 1004: return F<1004>()(std::forward<Args>(args)...);
        case 1005: return F<1005>()(std::forward<Args>(args)...);
        case 1006: return F<1006>()(std::forward<Args>(args)...);
        case 1007: return F<1007>()(std::forward<Args>(args)...);
        case 1008: return F<1008>()(std::forward<Args>(args)...);
        case 1009: return F<1009>()(std::forward<Args>(args)...);
        case 1010: return F<1010>()(std::forward<Args>(args)...);
        case 1011: return F<1011>()(std::forward<Args>(args)...);
        case 1012: return F<1012>()(std::forward<Args>(args)...);
        case 1013: return F<1013>()(std::forward<Args>(args)...);
        case 1014: return F<1014>()(std::forward<Args>(args)...);
        case 1015: return F<1015>()(std::forward<Args>(args)...);
        case 1016: return F<1016>()(std::forward<Args>(args)...);
        case 1017: return F<1017>()(std::forward<Args>(args)...);
        case 1018: return F<1018>()(std::forward<Args>(args)...);
        case 1019: return F<1019>()(std::forward<Args>(args)...);
        case 1020: return F<1020>()(std::forward<Args>(args)...);
        case 1021: return F<1021>()(std::forward<Args>(args)...);
        case 1022: return F<1022>()(std::forward<Args>(args)...);
        case 1023: return F<1023>()(std::forward<Args>(args)...);
        case 1024: return F<1024>()(std::forward<Args>(args)...);
        case 1025: return F<1025>()(std::forward<Args>(args)...);
        case 1026: return F<1026>()(std::forward<Args>(args)...);
        case 1027: return F<1027>()(std::forward<Args>(args)...);
        case 1028: return F<1028>()(std::forward<Args>(args)...);
        case 1029: return F<1029>()(std::forward<Args>(args)...);
        case 1030: return F<1030>()(std::forward<Args>(args)...);
        case 1031: return F<1031>()(std::forward<Args>(args)...);
        case 1032: return F<1032>()(std::forward<Args>(args)...);
        case 1033: return F<1033>()(std::forward<Args>(args)...);
        case 1034: return F<1034>()(std::forward<Args>(args)...);
        case 1035: return F<1035>()(std::forward<Args>(args)...);
        case 1036: return F<1036>()(std::forward<Args>(args)...);
        case 1037: return F<1037>()(std::forward<Args>(args)...);
        case 1038: return F<1038>()(std::forward<Args>(args)...);
        case 1039: return F<1039>()(std::forward<Args>(args)...);
        case 1040: return F<1040>()(std::forward<Args>(args)...);
        case 1041: return F<1041>()(std::forward<Args>(args)...);
        case 1042: return F<1042>()(std::forward<Args>(args)...);
        case 1043: return F<1043>()(std::forward<Args>(args)...);
        case 1044: return F<1044>()(std::forward<Args>(args)...);
        case 1045: return F<1045>()(std::forward<Args>(args)...);
        case 1046: return F<1046>()(std::forward<Args>(args)...);
        case 1047: return F<1047>()(std::forward<Args>(args)...);
        case 1048: return F<1048>()(std::forward<Args>(args)...);
        case 1049: return F<1049>()(std::forward<Args>(args)...);
        case 1050: return F<1050>()(std::forward<Args>(args)...);
        case 1051: return F<1051>()(std::forward<Args>(args)...);
        case 1052: return F<1052>()(std::forward<Args>(args)...);
        case 1053: return F<1053>()(std::forward<Args>(args)...);
        case 1054: return F<1054>()(std::forward<Args>(args)...);
        case 1055: return F<1055>()(std::forward<Args>(args)...);
        case 1056: return F<1056>()(std::forward<Args>(args)...);
        case 1057: return F<1057>()(std::forward<Args>(args)...);
        case 1058: return F<1058>()(std::forward<Args>(args)...);
        case 1059: return F<1059>()(std::forward<Args>(args)...);
        case 1060: return F<1060>()(std::forward<Args>(args)...);
        case 1061: return F<1061>()(std::forward<Args>(args)...);
        case 1062: return F<1062>()(std::forward<Args>(args)...);
        case 1063: return F<1063>()(std::forward<Args>(args)...);
        case 1064: return F<1064>()(std::forward<Args>(args)...);
        case 1065: return F<1065>()(std::forward<Args>(args)...);
        case 1066: return F<1066>()(std::forward<Args>(args)...);
        case 1067: return F<1067>()(std::forward<Args>(args)...);
        case 1068: return F<1068>()(std::forward<Args>(args)...);
        case 1069: return F<1069>()(std::forward<Args>(args)...);
        case 1070: return F<1070>()(std::forward<Args>(args)...);
        case 1071: return F<1071>()(std::forward<Args>(args)...);
        case 1072: return F<1072>()(std::forward<Args>(args)...);
        case 1073: return F<1073>()(std::forward<Args>(args)...);
        case 1074: return F<1074>()(std::forward<Args>(args)...);
        case 1075: return F<1075>()(std::forward<Args>(args)...);
        case 2003: return F<2003>()(std::forward<Args>(args)...);
        case 2002: return F<2002>()(std::forward<Args>(args)...);
        case 2001: return F<2001>()(std::forward<Args>(args)...);
        case 2000: return F<2000>()(std::forward<Args>(args)...);
        case 2004: return F<2004>()(std::forward<Args>(args)...);
        case 2005: return F<2005>()(std::forward<Args>(args)...);
        case 2006: return F<2006>()(std::forward<Args>(args)...);
        case 2007: return F<2007>()(std::forward<Args>(args)...);
        case 2008: return F<2008>()(std::forward<Args>(args)...);
        case 2009: return F<2009>()(std::forward<Args>(args)...);
        case 2010: return F<2010>()(std::forward<Args>(args)...);
        case 2011: return F<2011>()(std::forward<Args>(args)...);
        case 2208: return F<2208>()(std::forward<Args>(args)...);
        case 2209: return F<2209>()(std::forward<Args>(args)...);
        case 2210: return F<2210>()(std::forward<Args>(args)...);
        case 2211: return F<2211>()(std::forward<Args>(args)...);
        case 2104: return F<2104>()(std::forward<Args>(args)...);
        case 2105: return F<2105>()(std::forward<Args>(args)...);
        case 2106: return F<2106>()(std::forward<Args>(args)...);
        case 2107: return F<2107>()(std::forward<Args>(args)...);
        case 2012: return F<2012>()(std::forward<Args>(args)...);
        case 2013: return F<2013>()(std::forward<Args>(args)...);
        case 2014: return F<2014>()(std::forward<Args>(args)...);
        case 2015: return F<2015>()(std::forward<Args>(args)...);
        case 2016: return F<2016>()(std::forward<Args>(args)...);
        case 2017: return F<2017>()(std::forward<Args>(args)...);
        case 203: return F<203>()(std::forward<Args>(args)...);
        default: return F<ANARI_UNKNOWN>()(std::forward<Args>(args)...);
    }
}
#endif

inline size_t sizeOf(ANARIDataType type) {
    switch (type) {
        case ANARI_UNKNOWN: return sizeof(int)*1;
        case ANARI_DATA_TYPE: return sizeof(int32_t)*1;
        case ANARI_STRING: return sizeof(const char*)*1;
        case ANARI_VOID_POINTER: return sizeof(void*)*1;
        case ANARI_BOOL: return sizeof(int8_t)*1;
        case ANARI_STRING_LIST: return sizeof(const char**)*1;
        case ANARI_DATA_TYPE_LIST: return sizeof(ANARIDataType*)*1;
        case ANARI_PARAMETER_LIST: return sizeof(ANARIParameter*)*1;
        case ANARI_FUNCTION_POINTER: return sizeof(void(*)(void))*1;
        case ANARI_MEMORY_DELETER: return sizeof(ANARIMemoryDeleter)*1;
        case ANARI_STATUS_CALLBACK: return sizeof(ANARIStatusCallback)*1;
        case ANARI_LIBRARY: return sizeof(ANARILibrary)*1;
        case ANARI_DEVICE: return sizeof(ANARIDevice)*1;
        case ANARI_OBJECT: return sizeof(ANARIObject)*1;
        case ANARI_ARRAY: return sizeof(ANARIArray)*1;
        case ANARI_ARRAY1D: return sizeof(ANARIArray1D)*1;
        case ANARI_ARRAY2D: return sizeof(ANARIArray2D)*1;
        case ANARI_ARRAY3D: return sizeof(ANARIArray3D)*1;
        case ANARI_CAMERA: return sizeof(ANARICamera)*1;
        case ANARI_FRAME: return sizeof(ANARIFrame)*1;
        case ANARI_GEOMETRY: return sizeof(ANARIGeometry)*1;
        case ANARI_GROUP: return sizeof(ANARIGroup)*1;
        case ANARI_INSTANCE: return sizeof(ANARIInstance)*1;
        case ANARI_LIGHT: return sizeof(ANARILight)*1;
        case ANARI_MATERIAL: return sizeof(ANARIMaterial)*1;
        case ANARI_RENDERER: return sizeof(ANARIRenderer)*1;
        case ANARI_SURFACE: return sizeof(ANARISurface)*1;
        case ANARI_SAMPLER: return sizeof(ANARISampler)*1;
        case ANARI_SPATIAL_FIELD: return sizeof(ANARISpatialField)*1;
        case ANARI_VOLUME: return sizeof(ANARIVolume)*1;
        case ANARI_WORLD: return sizeof(ANARIWorld)*1;
        case ANARI_INT8: return sizeof(int8_t)*1;
        case ANARI_INT8_VEC2: return sizeof(int8_t)*2;
        case ANARI_INT8_VEC3: return sizeof(int8_t)*3;
        case ANARI_INT8_VEC4: return sizeof(int8_t)*4;
        case ANARI_UINT8: return sizeof(uint8_t)*1;
        case ANARI_UINT8_VEC2: return sizeof(uint8_t)*2;
        case ANARI_UINT8_VEC3: return sizeof(uint8_t)*3;
        case ANARI_UINT8_VEC4: return sizeof(uint8_t)*4;
        case ANARI_INT16: return sizeof(int16_t)*1;
        case ANARI_INT16_VEC2: return sizeof(int16_t)*2;
        case ANARI_INT16_VEC3: return sizeof(int16_t)*3;
        case ANARI_INT16_VEC4: return sizeof(int16_t)*4;
        case ANARI_UINT16: return sizeof(uint16_t)*1;
        case ANARI_UINT16_VEC2: return sizeof(uint16_t)*2;
        case ANARI_UINT16_VEC3: return sizeof(uint16_t)*3;
        case ANARI_UINT16_VEC4: return sizeof(uint16_t)*4;
        case ANARI_INT32: return sizeof(int32_t)*1;
        case ANARI_INT32_VEC2: return sizeof(int32_t)*2;
        case ANARI_INT32_VEC3: return sizeof(int32_t)*3;
        case ANARI_INT32_VEC4: return sizeof(int32_t)*4;
        case ANARI_UINT32: return sizeof(uint32_t)*1;
        case ANARI_UINT32_VEC2: return sizeof(uint32_t)*2;
        case ANARI_UINT32_VEC3: return sizeof(uint32_t)*3;
        case ANARI_UINT32_VEC4: return sizeof(uint32_t)*4;
        case ANARI_INT64: return sizeof(int64_t)*1;
        case ANARI_INT64_VEC2: return sizeof(int64_t)*2;
        case ANARI_INT64_VEC3: return sizeof(int64_t)*3;
        case ANARI_INT64_VEC4: return sizeof(int64_t)*4;
        case ANARI_UINT64: return sizeof(uint64_t)*1;
        case ANARI_UINT64_VEC2: return sizeof(uint64_t)*2;
        case ANARI_UINT64_VEC3: return sizeof(uint64_t)*3;
        case ANARI_UINT64_VEC4: return sizeof(uint64_t)*4;
        case ANARI_FIXED8: return sizeof(int8_t)*1;
        case ANARI_FIXED8_VEC2: return sizeof(int8_t)*2;
        case ANARI_FIXED8_VEC3: return sizeof(int8_t)*3;
        case ANARI_FIXED8_VEC4: return sizeof(int8_t)*4;
        case ANARI_UFIXED8: return sizeof(uint8_t)*1;
        case ANARI_UFIXED8_VEC2: return sizeof(uint8_t)*2;
        case ANARI_UFIXED8_VEC3: return sizeof(uint8_t)*3;
        case ANARI_UFIXED8_VEC4: return sizeof(uint8_t)*4;
        case ANARI_FIXED16: return sizeof(int16_t)*1;
        case ANARI_FIXED16_VEC2: return sizeof(int16_t)*2;
        case ANARI_FIXED16_VEC3: return sizeof(int16_t)*3;
        case ANARI_FIXED16_VEC4: return sizeof(int16_t)*4;
        case ANARI_UFIXED16: return sizeof(uint16_t)*1;
        case ANARI_UFIXED16_VEC2: return sizeof(uint16_t)*2;
        case ANARI_UFIXED16_VEC3: return sizeof(uint16_t)*3;
        case ANARI_UFIXED16_VEC4: return sizeof(uint16_t)*4;
        case ANARI_FIXED32: return sizeof(int32_t)*1;
        case ANARI_FIXED32_VEC2: return sizeof(int32_t)*2;
        case ANARI_FIXED32_VEC3: return sizeof(int32_t)*3;
        case ANARI_FIXED32_VEC4: return sizeof(int32_t)*4;
        case ANARI_UFIXED32: return sizeof(uint32_t)*1;
        case ANARI_UFIXED32_VEC2: return sizeof(uint32_t)*2;
        case ANARI_UFIXED32_VEC3: return sizeof(uint32_t)*3;
        case ANARI_UFIXED32_VEC4: return sizeof(uint32_t)*4;
        case ANARI_FIXED64: return sizeof(int64_t)*1;
        case ANARI_FIXED64_VEC2: return sizeof(int64_t)*2;
        case ANARI_FIXED64_VEC3: return sizeof(int64_t)*3;
        case ANARI_FIXED64_VEC4: return sizeof(int64_t)*4;
        case ANARI_UFIXED64: return sizeof(uint64_t)*1;
        case ANARI_UFIXED64_VEC2: return sizeof(uint64_t)*2;
        case ANARI_UFIXED64_VEC3: return sizeof(uint64_t)*3;
        case ANARI_UFIXED64_VEC4: return sizeof(uint64_t)*4;
        case ANARI_FLOAT16: return sizeof(uint16_t)*1;
        case ANARI_FLOAT16_VEC2: return sizeof(uint16_t)*2;
        case ANARI_FLOAT16_VEC3: return sizeof(uint16_t)*3;
        case ANARI_FLOAT16_VEC4: return sizeof(uint16_t)*4;
        case ANARI_FLOAT32: return sizeof(float)*1;
        case ANARI_FLOAT32_VEC2: return sizeof(float)*2;
        case ANARI_FLOAT32_VEC3: return sizeof(float)*3;
        case ANARI_FLOAT32_VEC4: return sizeof(float)*4;
        case ANARI_FLOAT64: return sizeof(double)*1;
        case ANARI_FLOAT64_VEC2: return sizeof(double)*2;
        case ANARI_FLOAT64_VEC3: return sizeof(double)*3;
        case ANARI_FLOAT64_VEC4: return sizeof(double)*4;
        case ANARI_UFIXED8_RGBA_SRGB: return sizeof(uint8_t)*4;
        case ANARI_UFIXED8_RGB_SRGB: return sizeof(uint8_t)*3;
        case ANARI_UFIXED8_RA_SRGB: return sizeof(uint8_t)*2;
        case ANARI_UFIXED8_R_SRGB: return sizeof(uint8_t)*1;
        case ANARI_INT32_BOX1: return sizeof(int32_t)*2;
        case ANARI_INT32_BOX2: return sizeof(int32_t)*4;
        case ANARI_INT32_BOX3: return sizeof(int32_t)*6;
        case ANARI_INT32_BOX4: return sizeof(int32_t)*8;
        case ANARI_FLOAT32_BOX1: return sizeof(float)*2;
        case ANARI_FLOAT32_BOX2: return sizeof(float)*4;
        case ANARI_FLOAT32_BOX3: return sizeof(float)*6;
        case ANARI_FLOAT32_BOX4: return sizeof(float)*8;
        case ANARI_FLOAT64_BOX1: return sizeof(double)*2;
        case ANARI_FLOAT64_BOX2: return sizeof(double)*4;
        case ANARI_FLOAT64_BOX3: return sizeof(double)*6;
        case ANARI_FLOAT64_BOX4: return sizeof(double)*8;
        case ANARI_UINT64_REGION1: return sizeof(uint64_t)*2;
        case ANARI_UINT64_REGION2: return sizeof(uint64_t)*4;
        case ANARI_UINT64_REGION3: return sizeof(uint64_t)*6;
        case ANARI_UINT64_REGION4: return sizeof(uint64_t)*8;
        case ANARI_FLOAT32_MAT2: return sizeof(float)*4;
        case ANARI_FLOAT32_MAT3: return sizeof(float)*9;
        case ANARI_FLOAT32_MAT4: return sizeof(float)*16;
        case ANARI_FLOAT32_MAT2x3: return sizeof(float)*6;
        case ANARI_FLOAT32_MAT3x4: return sizeof(float)*12;
        case ANARI_FLOAT32_QUAT_IJKW: return sizeof(float)*4;
        case ANARI_FRAME_COMPLETION_CALLBACK: return sizeof(ANARIFrameCompletionCallback)*1;
        default: return 4;
    }
}

inline size_t componentsOf(ANARIDataType type) {
    switch (type) {
        case ANARI_UNKNOWN: return 1;
        case ANARI_DATA_TYPE: return 1;
        case ANARI_STRING: return 1;
        case ANARI_VOID_POINTER: return 1;
        case ANARI_BOOL: return 1;
        case ANARI_STRING_LIST: return 1;
        case ANARI_DATA_TYPE_LIST: return 1;
        case ANARI_PARAMETER_LIST: return 1;
        case ANARI_FUNCTION_POINTER: return 1;
        case ANARI_MEMORY_DELETER: return 1;
        case ANARI_STATUS_CALLBACK: return 1;
        case ANARI_LIBRARY: return 1;
        case ANARI_DEVICE: return 1;
        case ANARI_OBJECT: return 1;
        case ANARI_ARRAY: return 1;
        case ANARI_ARRAY1D: return 1;
        case ANARI_ARRAY2D: return 1;
        case ANARI_ARRAY3D: return 1;
        case ANARI_CAMERA: return 1;
        case ANARI_FRAME: return 1;
        case ANARI_GEOMETRY: return 1;
        case ANARI_GROUP: return 1;
        case ANARI_INSTANCE: return 1;
        case ANARI_LIGHT: return 1;
        case ANARI_MATERIAL: return 1;
        case ANARI_RENDERER: return 1;
        case ANARI_SURFACE: return 1;
        case ANARI_SAMPLER: return 1;
        case ANARI_SPATIAL_FIELD: return 1;
        case ANARI_VOLUME: return 1;
        case ANARI_WORLD: return 1;
        case ANARI_INT8: return 1;
        case ANARI_INT8_VEC2: return 2;
        case ANARI_INT8_VEC3: return 3;
        case ANARI_INT8_VEC4: return 4;
        case ANARI_UINT8: return 1;
        case ANARI_UINT8_VEC2: return 2;
        case ANARI_UINT8_VEC3: return 3;
        case ANARI_UINT8_VEC4: return 4;
        case ANARI_INT16: return 1;
        case ANARI_INT16_VEC2: return 2;
        case ANARI_INT16_VEC3: return 3;
        case ANARI_INT16_VEC4: return 4;
        case ANARI_UINT16: return 1;
        case ANARI_UINT16_VEC2: return 2;
        case ANARI_UINT16_VEC3: return 3;
        case ANARI_UINT16_VEC4: return 4;
        case ANARI_INT32: return 1;
        case ANARI_INT32_VEC2: return 2;
        case ANARI_INT32_VEC3: return 3;
        case ANARI_INT32_VEC4: return 4;
        case ANARI_UINT32: return 1;
        case ANARI_UINT32_VEC2: return 2;
        case ANARI_UINT32_VEC3: return 3;
        case ANARI_UINT32_VEC4: return 4;
        case ANARI_INT64: return 1;
        case ANARI_INT64_VEC2: return 2;
        case ANARI_INT64_VEC3: return 3;
        case ANARI_INT64_VEC4: return 4;
        case ANARI_UINT64: return 1;
        case ANARI_UINT64_VEC2: return 2;
        case ANARI_UINT64_VEC3: return 3;
        case ANARI_UINT64_VEC4: return 4;
        case ANARI_FIXED8: return 1;
        case ANARI_FIXED8_VEC2: return 2;
        case ANARI_FIXED8_VEC3: return 3;
        case ANARI_FIXED8_VEC4: return 4;
        case ANARI_UFIXED8: return 1;
        case ANARI_UFIXED8_VEC2: return 2;
        case ANARI_UFIXED8_VEC3: return 3;
        case ANARI_UFIXED8_VEC4: return 4;
        case ANARI_FIXED16: return 1;
        case ANARI_FIXED16_VEC2: return 2;
        case ANARI_FIXED16_VEC3: return 3;
        case ANARI_FIXED16_VEC4: return 4;
        case ANARI_UFIXED16: return 1;
        case ANARI_UFIXED16_VEC2: return 2;
        case ANARI_UFIXED16_VEC3: return 3;
        case ANARI_UFIXED16_VEC4: return 4;
        case ANARI_FIXED32: return 1;
        case ANARI_FIXED32_VEC2: return 2;
        case ANARI_FIXED32_VEC3: return 3;
        case ANARI_FIXED32_VEC4: return 4;
        case ANARI_UFIXED32: return 1;
        case ANARI_UFIXED32_VEC2: return 2;
        case ANARI_UFIXED32_VEC3: return 3;
        case ANARI_UFIXED32_VEC4: return 4;
        case ANARI_FIXED64: return 1;
        case ANARI_FIXED64_VEC2: return 2;
        case ANARI_FIXED64_VEC3: return 3;
        case ANARI_FIXED64_VEC4: return 4;
        case ANARI_UFIXED64: return 1;
        case ANARI_UFIXED64_VEC2: return 2;
        case ANARI_UFIXED64_VEC3: return 3;
        case ANARI_UFIXED64_VEC4: return 4;
        case ANARI_FLOAT16: return 1;
        case ANARI_FLOAT16_VEC2: return 2;
        case ANARI_FLOAT16_VEC3: return 3;
        case ANARI_FLOAT16_VEC4: return 4;
        case ANARI_FLOAT32: return 1;
        case ANARI_FLOAT32_VEC2: return 2;
        case ANARI_FLOAT32_VEC3: return 3;
        case ANARI_FLOAT32_VEC4: return 4;
        case ANARI_FLOAT64: return 1;
        case ANARI_FLOAT64_VEC2: return 2;
        case ANARI_FLOAT64_VEC3: return 3;
        case ANARI_FLOAT64_VEC4: return 4;
        case ANARI_UFIXED8_RGBA_SRGB: return 4;
        case ANARI_UFIXED8_RGB_SRGB: return 3;
        case ANARI_UFIXED8_RA_SRGB: return 2;
        case ANARI_UFIXED8_R_SRGB: return 1;
        case ANARI_INT32_BOX1: return 2;
        case ANARI_INT32_BOX2: return 4;
        case ANARI_INT32_BOX3: return 6;
        case ANARI_INT32_BOX4: return 8;
        case ANARI_FLOAT32_BOX1: return 2;
        case ANARI_FLOAT32_BOX2: return 4;
        case ANARI_FLOAT32_BOX3: return 6;
        case ANARI_FLOAT32_BOX4: return 8;
        case ANARI_FLOAT64_BOX1: return 2;
        case ANARI_FLOAT64_BOX2: return 4;
        case ANARI_FLOAT64_BOX3: return 6;
        case ANARI_FLOAT64_BOX4: return 8;
        case ANARI_UINT64_REGION1: return 2;
        case ANARI_UINT64_REGION2: return 4;
        case ANARI_UINT64_REGION3: return 6;
        case ANARI_UINT64_REGION4: return 8;
        case ANARI_FLOAT32_MAT2: return 4;
        case ANARI_FLOAT32_MAT3: return 9;
        case ANARI_FLOAT32_MAT4: return 16;
        case ANARI_FLOAT32_MAT2x3: return 6;
        case ANARI_FLOAT32_MAT3x4: return 12;
        case ANARI_FLOAT32_QUAT_IJKW: return 4;
        case ANARI_FRAME_COMPLETION_CALLBACK: return 1;
        default: return 1;
    }
}

inline const char* toString(ANARIDataType type) {
    switch (type) {
        case ANARI_UNKNOWN: return "ANARI_UNKNOWN";
        case ANARI_DATA_TYPE: return "ANARI_DATA_TYPE";
        case ANARI_STRING: return "ANARI_STRING";
        case ANARI_VOID_POINTER: return "ANARI_VOID_POINTER";
        case ANARI_BOOL: return "ANARI_BOOL";
        case ANARI_STRING_LIST: return "ANARI_STRING_LIST";
        case ANARI_DATA_TYPE_LIST: return "ANARI_DATA_TYPE_LIST";
        case ANARI_PARAMETER_LIST: return "ANARI_PARAMETER_LIST";
        case ANARI_FUNCTION_POINTER: return "ANARI_FUNCTION_POINTER";
        case ANARI_MEMORY_DELETER: return "ANARI_MEMORY_DELETER";
        case ANARI_STATUS_CALLBACK: return "ANARI_STATUS_CALLBACK";
        case ANARI_LIBRARY: return "ANARI_LIBRARY";
        case ANARI_DEVICE: return "ANARI_DEVICE";
        case ANARI_OBJECT: return "ANARI_OBJECT";
        case ANARI_ARRAY: return "ANARI_ARRAY";
        case ANARI_ARRAY1D: return "ANARI_ARRAY1D";
        case ANARI_ARRAY2D: return "ANARI_ARRAY2D";
        case ANARI_ARRAY3D: return "ANARI_ARRAY3D";
        case ANARI_CAMERA: return "ANARI_CAMERA";
        case ANARI_FRAME: return "ANARI_FRAME";
        case ANARI_GEOMETRY: return "ANARI_GEOMETRY";
        case ANARI_GROUP: return "ANARI_GROUP";
        case ANARI_INSTANCE: return "ANARI_INSTANCE";
        case ANARI_LIGHT: return "ANARI_LIGHT";
        case ANARI_MATERIAL: return "ANARI_MATERIAL";
        case ANARI_RENDERER: return "ANARI_RENDERER";
        case ANARI_SURFACE: return "ANARI_SURFACE";
        case ANARI_SAMPLER: return "ANARI_SAMPLER";
        case ANARI_SPATIAL_FIELD: return "ANARI_SPATIAL_FIELD";
        case ANARI_VOLUME: return "ANARI_VOLUME";
        case ANARI_WORLD: return "ANARI_WORLD";
        case ANARI_INT8: return "ANARI_INT8";
        case ANARI_INT8_VEC2: return "ANARI_INT8_VEC2";
        case ANARI_INT8_VEC3: return "ANARI_INT8_VEC3";
        case ANARI_INT8_VEC4: return "ANARI_INT8_VEC4";
        case ANARI_UINT8: return "ANARI_UINT8";
        case ANARI_UINT8_VEC2: return "ANARI_UINT8_VEC2";
        case ANARI_UINT8_VEC3: return "ANARI_UINT8_VEC3";
        case ANARI_UINT8_VEC4: return "ANARI_UINT8_VEC4";
        case ANARI_INT16: return "ANARI_INT16";
        case ANARI_INT16_VEC2: return "ANARI_INT16_VEC2";
        case ANARI_INT16_VEC3: return "ANARI_INT16_VEC3";
        case ANARI_INT16_VEC4: return "ANARI_INT16_VEC4";
        case ANARI_UINT16: return "ANARI_UINT16";
        case ANARI_UINT16_VEC2: return "ANARI_UINT16_VEC2";
        case ANARI_UINT16_VEC3: return "ANARI_UINT16_VEC3";
        case ANARI_UINT16_VEC4: return "ANARI_UINT16_VEC4";
        case ANARI_INT32: return "ANARI_INT32";
        case ANARI_INT32_VEC2: return "ANARI_INT32_VEC2";
        case ANARI_INT32_VEC3: return "ANARI_INT32_VEC3";
        case ANARI_INT32_VEC4: return "ANARI_INT32_VEC4";
        case ANARI_UINT32: return "ANARI_UINT32";
        case ANARI_UINT32_VEC2: return "ANARI_UINT32_VEC2";
        case ANARI_UINT32_VEC3: return "ANARI_UINT32_VEC3";
        case ANARI_UINT32_VEC4: return "ANARI_UINT32_VEC4";
        case ANARI_INT64: return "ANARI_INT64";
        case ANARI_INT64_VEC2: return "ANARI_INT64_VEC2";
        case ANARI_INT64_VEC3: return "ANARI_INT64_VEC3";
        case ANARI_INT64_VEC4: return "ANARI_INT64_VEC4";
        case ANARI_UINT64: return "ANARI_UINT64";
        case ANARI_UINT64_VEC2: return "ANARI_UINT64_VEC2";
        case ANARI_UINT64_VEC3: return "ANARI_UINT64_VEC3";
        case ANARI_UINT64_VEC4: return "ANARI_UINT64_VEC4";
        case ANARI_FIXED8: return "ANARI_FIXED8";
        case ANARI_FIXED8_VEC2: return "ANARI_FIXED8_VEC2";
        case ANARI_FIXED8_VEC3: return "ANARI_FIXED8_VEC3";
        case ANARI_FIXED8_VEC4: return "ANARI_FIXED8_VEC4";
        case ANARI_UFIXED8: return "ANARI_UFIXED8";
        case ANARI_UFIXED8_VEC2: return "ANARI_UFIXED8_VEC2";
        case ANARI_UFIXED8_VEC3: return "ANARI_UFIXED8_VEC3";
        case ANARI_UFIXED8_VEC4: return "ANARI_UFIXED8_VEC4";
        case ANARI_FIXED16: return "ANARI_FIXED16";
        case ANARI_FIXED16_VEC2: return "ANARI_FIXED16_VEC2";
        case ANARI_FIXED16_VEC3: return "ANARI_FIXED16_VEC3";
        case ANARI_FIXED16_VEC4: return "ANARI_FIXED16_VEC4";
        case ANARI_UFIXED16: return "ANARI_UFIXED16";
        case ANARI_UFIXED16_VEC2: return "ANARI_UFIXED16_VEC2";
        case ANARI_UFIXED16_VEC3: return "ANARI_UFIXED16_VEC3";
        case ANARI_UFIXED16_VEC4: return "ANARI_UFIXED16_VEC4";
        case ANARI_FIXED32: return "ANARI_FIXED32";
        case ANARI_FIXED32_VEC2: return "ANARI_FIXED32_VEC2";
        case ANARI_FIXED32_VEC3: return "ANARI_FIXED32_VEC3";
        case ANARI_FIXED32_VEC4: return "ANARI_FIXED32_VEC4";
        case ANARI_UFIXED32: return "ANARI_UFIXED32";
        case ANARI_UFIXED32_VEC2: return "ANARI_UFIXED32_VEC2";
        case ANARI_UFIXED32_VEC3: return "ANARI_UFIXED32_VEC3";
        case ANARI_UFIXED32_VEC4: return "ANARI_UFIXED32_VEC4";
        case ANARI_FIXED64: return "ANARI_FIXED64";
        case ANARI_FIXED64_VEC2: return "ANARI_FIXED64_VEC2";
        case ANARI_FIXED64_VEC3: return "ANARI_FIXED64_VEC3";
        case ANARI_FIXED64_VEC4: return "ANARI_FIXED64_VEC4";
        case ANARI_UFIXED64: return "ANARI_UFIXED64";
        case ANARI_UFIXED64_VEC2: return "ANARI_UFIXED64_VEC2";
        case ANARI_UFIXED64_VEC3: return "ANARI_UFIXED64_VEC3";
        case ANARI_UFIXED64_VEC4: return "ANARI_UFIXED64_VEC4";
        case ANARI_FLOAT16: return "ANARI_FLOAT16";
        case ANARI_FLOAT16_VEC2: return "ANARI_FLOAT16_VEC2";
        case ANARI_FLOAT16_VEC3: return "ANARI_FLOAT16_VEC3";
        case ANARI_FLOAT16_VEC4: return "ANARI_FLOAT16_VEC4";
        case ANARI_FLOAT32: return "ANARI_FLOAT32";
        case ANARI_FLOAT32_VEC2: return "ANARI_FLOAT32_VEC2";
        case ANARI_FLOAT32_VEC3: return "ANARI_FLOAT32_VEC3";
        case ANARI_FLOAT32_VEC4: return "ANARI_FLOAT32_VEC4";
        case ANARI_FLOAT64: return "ANARI_FLOAT64";
        case ANARI_FLOAT64_VEC2: return "ANARI_FLOAT64_VEC2";
        case ANARI_FLOAT64_VEC3: return "ANARI_FLOAT64_VEC3";
        case ANARI_FLOAT64_VEC4: return "ANARI_FLOAT64_VEC4";
        case ANARI_UFIXED8_RGBA_SRGB: return "ANARI_UFIXED8_RGBA_SRGB";
        case ANARI_UFIXED8_RGB_SRGB: return "ANARI_UFIXED8_RGB_SRGB";
        case ANARI_UFIXED8_RA_SRGB: return "ANARI_UFIXED8_RA_SRGB";
        case ANARI_UFIXED8_R_SRGB: return "ANARI_UFIXED8_R_SRGB";
        case ANARI_INT32_BOX1: return "ANARI_INT32_BOX1";
        case ANARI_INT32_BOX2: return "ANARI_INT32_BOX2";
        case ANARI_INT32_BOX3: return "ANARI_INT32_BOX3";
        case ANARI_INT32_BOX4: return "ANARI_INT32_BOX4";
        case ANARI_FLOAT32_BOX1: return "ANARI_FLOAT32_BOX1";
        case ANARI_FLOAT32_BOX2: return "ANARI_FLOAT32_BOX2";
        case ANARI_FLOAT32_BOX3: return "ANARI_FLOAT32_BOX3";
        case ANARI_FLOAT32_BOX4: return "ANARI_FLOAT32_BOX4";
        case ANARI_FLOAT64_BOX1: return "ANARI_FLOAT64_BOX1";
        case ANARI_FLOAT64_BOX2: return "ANARI_FLOAT64_BOX2";
        case ANARI_FLOAT64_BOX3: return "ANARI_FLOAT64_BOX3";
        case ANARI_FLOAT64_BOX4: return "ANARI_FLOAT64_BOX4";
        case ANARI_UINT64_REGION1: return "ANARI_UINT64_REGION1";
        case ANARI_UINT64_REGION2: return "ANARI_UINT64_REGION2";
        case ANARI_UINT64_REGION3: return "ANARI_UINT64_REGION3";
        case ANARI_UINT64_REGION4: return "ANARI_UINT64_REGION4";
        case ANARI_FLOAT32_MAT2: return "ANARI_FLOAT32_MAT2";
        case ANARI_FLOAT32_MAT3: return "ANARI_FLOAT32_MAT3";
        case ANARI_FLOAT32_MAT4: return "ANARI_FLOAT32_MAT4";
        case ANARI_FLOAT32_MAT2x3: return "ANARI_FLOAT32_MAT2x3";
        case ANARI_FLOAT32_MAT3x4: return "ANARI_FLOAT32_MAT3x4";
        case ANARI_FLOAT32_QUAT_IJKW: return "ANARI_FLOAT32_QUAT_IJKW";
        case ANARI_FRAME_COMPLETION_CALLBACK: return "ANARI_FRAME_COMPLETION_CALLBACK";
        default: return "ANARI_UNKNOWN";
    }
}

inline const char* typenameOf(ANARIDataType type) {
    switch (type) {
        case ANARI_UNKNOWN: return "int";
        case ANARI_DATA_TYPE: return "int32_t";
        case ANARI_STRING: return "const char*";
        case ANARI_VOID_POINTER: return "void*";
        case ANARI_BOOL: return "int8_t";
        case ANARI_STRING_LIST: return "const char**";
        case ANARI_DATA_TYPE_LIST: return "ANARIDataType*";
        case ANARI_PARAMETER_LIST: return "ANARIParameter*";
        case ANARI_FUNCTION_POINTER: return "void(*)(void)";
        case ANARI_MEMORY_DELETER: return "ANARIMemoryDeleter";
        case ANARI_STATUS_CALLBACK: return "ANARIStatusCallback";
        case ANARI_LIBRARY: return "ANARILibrary";
        case ANARI_DEVICE: return "ANARIDevice";
        case ANARI_OBJECT: return "ANARIObject";
        case ANARI_ARRAY: return "ANARIArray";
        case ANARI_ARRAY1D: return "ANARIArray1D";
        case ANARI_ARRAY2D: return "ANARIArray2D";
        case ANARI_ARRAY3D: return "ANARIArray3D";
        case ANARI_CAMERA: return "ANARICamera";
        case ANARI_FRAME: return "ANARIFrame";
        case ANARI_GEOMETRY: return "ANARIGeometry";
        case ANARI_GROUP: return "ANARIGroup";
        case ANARI_INSTANCE: return "ANARIInstance";
        case ANARI_LIGHT: return "ANARILight";
        case ANARI_MATERIAL: return "ANARIMaterial";
        case ANARI_RENDERER: return "ANARIRenderer";
        case ANARI_SURFACE: return "ANARISurface";
        case ANARI_SAMPLER: return "ANARISampler";
        case ANARI_SPATIAL_FIELD: return "ANARISpatialField";
        case ANARI_VOLUME: return "ANARIVolume";
        case ANARI_WORLD: return "ANARIWorld";
        case ANARI_INT8: return "int8_t";
        case ANARI_INT8_VEC2: return "int8_t";
        case ANARI_INT8_VEC3: return "int8_t";
        case ANARI_INT8_VEC4: return "int8_t";
        case ANARI_UINT8: return "uint8_t";
        case ANARI_UINT8_VEC2: return "uint8_t";
        case ANARI_UINT8_VEC3: return "uint8_t";
        case ANARI_UINT8_VEC4: return "uint8_t";
        case ANARI_INT16: return "int16_t";
        case ANARI_INT16_VEC2: return "int16_t";
        case ANARI_INT16_VEC3: return "int16_t";
        case ANARI_INT16_VEC4: return "int16_t";
        case ANARI_UINT16: return "uint16_t";
        case ANARI_UINT16_VEC2: return "uint16_t";
        case ANARI_UINT16_VEC3: return "uint16_t";
        case ANARI_UINT16_VEC4: return "uint16_t";
        case ANARI_INT32: return "int32_t";
        case ANARI_INT32_VEC2: return "int32_t";
        case ANARI_INT32_VEC3: return "int32_t";
        case ANARI_INT32_VEC4: return "int32_t";
        case ANARI_UINT32: return "uint32_t";
        case ANARI_UINT32_VEC2: return "uint32_t";
        case ANARI_UINT32_VEC3: return "uint32_t";
        case ANARI_UINT32_VEC4: return "uint32_t";
        case ANARI_INT64: return "int64_t";
        case ANARI_INT64_VEC2: return "int64_t";
        case ANARI_INT64_VEC3: return "int64_t";
        case ANARI_INT64_VEC4: return "int64_t";
        case ANARI_UINT64: return "uint64_t";
        case ANARI_UINT64_VEC2: return "uint64_t";
        case ANARI_UINT64_VEC3: return "uint64_t";
        case ANARI_UINT64_VEC4: return "uint64_t";
        case ANARI_FIXED8: return "int8_t";
        case ANARI_FIXED8_VEC2: return "int8_t";
        case ANARI_FIXED8_VEC3: return "int8_t";
        case ANARI_FIXED8_VEC4: return "int8_t";
        case ANARI_UFIXED8: return "uint8_t";
        case ANARI_UFIXED8_VEC2: return "uint8_t";
        case ANARI_UFIXED8_VEC3: return "uint8_t";
        case ANARI_UFIXED8_VEC4: return "uint8_t";
        case ANARI_FIXED16: return "int16_t";
        case ANARI_FIXED16_VEC2: return "int16_t";
        case ANARI_FIXED16_VEC3: return "int16_t";
        case ANARI_FIXED16_VEC4: return "int16_t";
        case ANARI_UFIXED16: return "uint16_t";
        case ANARI_UFIXED16_VEC2: return "uint16_t";
        case ANARI_UFIXED16_VEC3: return "uint16_t";
        case ANARI_UFIXED16_VEC4: return "uint16_t";
        case ANARI_FIXED32: return "int32_t";
        case ANARI_FIXED32_VEC2: return "int32_t";
        case ANARI_FIXED32_VEC3: return "int32_t";
        case ANARI_FIXED32_VEC4: return "int32_t";
        case ANARI_UFIXED32: return "uint32_t";
        case ANARI_UFIXED32_VEC2: return "uint32_t";
        case ANARI_UFIXED32_VEC3: return "uint32_t";
        case ANARI_UFIXED32_VEC4: return "uint32_t";
        case ANARI_FIXED64: return "int64_t";
        case ANARI_FIXED64_VEC2: return "int64_t";
        case ANARI_FIXED64_VEC3: return "int64_t";
        case ANARI_FIXED64_VEC4: return "int64_t";
        case ANARI_UFIXED64: return "uint64_t";
        case ANARI_UFIXED64_VEC2: return "uint64_t";
        case ANARI_UFIXED64_VEC3: return "uint64_t";
        case ANARI_UFIXED64_VEC4: return "uint64_t";
        case ANARI_FLOAT16: return "uint16_t";
        case ANARI_FLOAT16_VEC2: return "uint16_t";
        case ANARI_FLOAT16_VEC3: return "uint16_t";
        case ANARI_FLOAT16_VEC4: return "uint16_t";
        case ANARI_FLOAT32: return "float";
        case ANARI_FLOAT32_VEC2: return "float";
        case ANARI_FLOAT32_VEC3: return "float";
        case ANARI_FLOAT32_VEC4: return "float";
        case ANARI_FLOAT64: return "double";
        case ANARI_FLOAT64_VEC2: return "double";
        case ANARI_FLOAT64_VEC3: return "double";
        case ANARI_FLOAT64_VEC4: return "double";
        case ANARI_UFIXED8_RGBA_SRGB: return "uint8_t";
        case ANARI_UFIXED8_RGB_SRGB: return "uint8_t";
        case ANARI_UFIXED8_RA_SRGB: return "uint8_t";
        case ANARI_UFIXED8_R_SRGB: return "uint8_t";
        case ANARI_INT32_BOX1: return "int32_t";
        case ANARI_INT32_BOX2: return "int32_t";
        case ANARI_INT32_BOX3: return "int32_t";
        case ANARI_INT32_BOX4: return "int32_t";
        case ANARI_FLOAT32_BOX1: return "float";
        case ANARI_FLOAT32_BOX2: return "float";
        case ANARI_FLOAT32_BOX3: return "float";
        case ANARI_FLOAT32_BOX4: return "float";
        case ANARI_FLOAT64_BOX1: return "double";
        case ANARI_FLOAT64_BOX2: return "double";
        case ANARI_FLOAT64_BOX3: return "double";
        case ANARI_FLOAT64_BOX4: return "double";
        case ANARI_UINT64_REGION1: return "uint64_t";
        case ANARI_UINT64_REGION2: return "uint64_t";
        case ANARI_UINT64_REGION3: return "uint64_t";
        case ANARI_UINT64_REGION4: return "uint64_t";
        case ANARI_FLOAT32_MAT2: return "float";
        case ANARI_FLOAT32_MAT3: return "float";
        case ANARI_FLOAT32_MAT4: return "float";
        case ANARI_FLOAT32_MAT2x3: return "float";
        case ANARI_FLOAT32_MAT3x4: return "float";
        case ANARI_FLOAT32_QUAT_IJKW: return "float";
        case ANARI_FRAME_COMPLETION_CALLBACK: return "ANARIFrameCompletionCallback";
        default: return "ANARI_UNKNOWN";
    }
}

inline const char* varnameOf(ANARIDataType type) {
    switch (type) {
        case ANARI_UNKNOWN: return "varunknown";
        case ANARI_DATA_TYPE: return "vardata_type";
        case ANARI_STRING: return "varstring";
        case ANARI_VOID_POINTER: return "varvoid_pointer";
        case ANARI_BOOL: return "varbool";
        case ANARI_STRING_LIST: return "varstring_list";
        case ANARI_DATA_TYPE_LIST: return "vardata_type_list";
        case ANARI_PARAMETER_LIST: return "varparameter_list";
        case ANARI_FUNCTION_POINTER: return "varfunction_pointer";
        case ANARI_MEMORY_DELETER: return "varmemory_deleter";
        case ANARI_STATUS_CALLBACK: return "varstatus_callback";
        case ANARI_LIBRARY: return "varlibrary";
        case ANARI_DEVICE: return "vardevice";
        case ANARI_OBJECT: return "varobject";
        case ANARI_ARRAY: return "vararray";
        case ANARI_ARRAY1D: return "vararray1d";
        case ANARI_ARRAY2D: return "vararray2d";
        case ANARI_ARRAY3D: return "vararray3d";
        case ANARI_CAMERA: return "varcamera";
        case ANARI_FRAME: return "varframe";
        case ANARI_GEOMETRY: return "vargeometry";
        case ANARI_GROUP: return "vargroup";
        case ANARI_INSTANCE: return "varinstance";
        case ANARI_LIGHT: return "varlight";
        case ANARI_MATERIAL: return "varmaterial";
        case ANARI_RENDERER: return "varrenderer";
        case ANARI_SURFACE: return "varsurface";
        case ANARI_SAMPLER: return "varsampler";
        case ANARI_SPATIAL_FIELD: return "varspatial_field";
        case ANARI_VOLUME: return "varvolume";
        case ANARI_WORLD: return "varworld";
        case ANARI_INT8: return "varint8";
        case ANARI_INT8_VEC2: return "varint8_vec2";
        case ANARI_INT8_VEC3: return "varint8_vec3";
        case ANARI_INT8_VEC4: return "varint8_vec4";
        case ANARI_UINT8: return "varuint8";
        case ANARI_UINT8_VEC2: return "varuint8_vec2";
        case ANARI_UINT8_VEC3: return "varuint8_vec3";
        case ANARI_UINT8_VEC4: return "varuint8_vec4";
        case ANARI_INT16: return "varint16";
        case ANARI_INT16_VEC2: return "varint16_vec2";
        case ANARI_INT16_VEC3: return "varint16_vec3";
        case ANARI_INT16_VEC4: return "varint16_vec4";
        case ANARI_UINT16: return "varuint16";
        case ANARI_UINT16_VEC2: return "varuint16_vec2";
        case ANARI_UINT16_VEC3: return "varuint16_vec3";
        case ANARI_UINT16_VEC4: return "varuint16_vec4";
        case ANARI_INT32: return "varint32";
        case ANARI_INT32_VEC2: return "varint32_vec2";
        case ANARI_INT32_VEC3: return "varint32_vec3";
        case ANARI_INT32_VEC4: return "varint32_vec4";
        case ANARI_UINT32: return "varuint32";
        case ANARI_UINT32_VEC2: return "varuint32_vec2";
        case ANARI_UINT32_VEC3: return "varuint32_vec3";
        case ANARI_UINT32_VEC4: return "varuint32_vec4";
        case ANARI_INT64: return "varint64";
        case ANARI_INT64_VEC2: return "varint64_vec2";
        case ANARI_INT64_VEC3: return "varint64_vec3";
        case ANARI_INT64_VEC4: return "varint64_vec4";
        case ANARI_UINT64: return "varuint64";
        case ANARI_UINT64_VEC2: return "varuint64_vec2";
        case ANARI_UINT64_VEC3: return "varuint64_vec3";
        case ANARI_UINT64_VEC4: return "varuint64_vec4";
        case ANARI_FIXED8: return "varfixed8";
        case ANARI_FIXED8_VEC2: return "varfixed8_vec2";
        case ANARI_FIXED8_VEC3: return "varfixed8_vec3";
        case ANARI_FIXED8_VEC4: return "varfixed8_vec4";
        case ANARI_UFIXED8: return "varufixed8";
        case ANARI_UFIXED8_VEC2: return "varufixed8_vec2";
        case ANARI_UFIXED8_VEC3: return "varufixed8_vec3";
        case ANARI_UFIXED8_VEC4: return "varufixed8_vec4";
        case ANARI_FIXED16: return "varfixed16";
        case ANARI_FIXED16_VEC2: return "varfixed16_vec2";
        case ANARI_FIXED16_VEC3: return "varfixed16_vec3";
        case ANARI_FIXED16_VEC4: return "varfixed16_vec4";
        case ANARI_UFIXED16: return "varufixed16";
        case ANARI_UFIXED16_VEC2: return "varufixed16_vec2";
        case ANARI_UFIXED16_VEC3: return "varufixed16_vec3";
        case ANARI_UFIXED16_VEC4: return "varufixed16_vec4";
        case ANARI_FIXED32: return "varfixed32";
        case ANARI_FIXED32_VEC2: return "varfixed32_vec2";
        case ANARI_FIXED32_VEC3: return "varfixed32_vec3";
        case ANARI_FIXED32_VEC4: return "varfixed32_vec4";
        case ANARI_UFIXED32: return "varufixed32";
        case ANARI_UFIXED32_VEC2: return "varufixed32_vec2";
        case ANARI_UFIXED32_VEC3: return "varufixed32_vec3";
        case ANARI_UFIXED32_VEC4: return "varufixed32_vec4";
        case ANARI_FIXED64: return "varfixed64";
        case ANARI_FIXED64_VEC2: return "varfixed64_vec2";
        case ANARI_FIXED64_VEC3: return "varfixed64_vec3";
        case ANARI_FIXED64_VEC4: return "varfixed64_vec4";
        case ANARI_UFIXED64: return "varufixed64";
        case ANARI_UFIXED64_VEC2: return "varufixed64_vec2";
        case ANARI_UFIXED64_VEC3: return "varufixed64_vec3";
        case ANARI_UFIXED64_VEC4: return "varufixed64_vec4";
        case ANARI_FLOAT16: return "varfloat16";
        case ANARI_FLOAT16_VEC2: return "varfloat16_vec2";
        case ANARI_FLOAT16_VEC3: return "varfloat16_vec3";
        case ANARI_FLOAT16_VEC4: return "varfloat16_vec4";
        case ANARI_FLOAT32: return "varfloat32";
        case ANARI_FLOAT32_VEC2: return "varfloat32_vec2";
        case ANARI_FLOAT32_VEC3: return "varfloat32_vec3";
        case ANARI_FLOAT32_VEC4: return "varfloat32_vec4";
        case ANARI_FLOAT64: return "varfloat64";
        case ANARI_FLOAT64_VEC2: return "varfloat64_vec2";
        case ANARI_FLOAT64_VEC3: return "varfloat64_vec3";
        case ANARI_FLOAT64_VEC4: return "varfloat64_vec4";
        case ANARI_UFIXED8_RGBA_SRGB: return "varufixed8_rgba_srgb";
        case ANARI_UFIXED8_RGB_SRGB: return "varufixed8_rgb_srgb";
        case ANARI_UFIXED8_RA_SRGB: return "varufixed8_ra_srgb";
        case ANARI_UFIXED8_R_SRGB: return "varufixed8_r_srgb";
        case ANARI_INT32_BOX1: return "varint32_box1";
        case ANARI_INT32_BOX2: return "varint32_box2";
        case ANARI_INT32_BOX3: return "varint32_box3";
        case ANARI_INT32_BOX4: return "varint32_box4";
        case ANARI_FLOAT32_BOX1: return "varfloat32_box1";
        case ANARI_FLOAT32_BOX2: return "varfloat32_box2";
        case ANARI_FLOAT32_BOX3: return "varfloat32_box3";
        case ANARI_FLOAT32_BOX4: return "varfloat32_box4";
        case ANARI_FLOAT64_BOX1: return "varfloat64_box1";
        case ANARI_FLOAT64_BOX2: return "varfloat64_box2";
        case ANARI_FLOAT64_BOX3: return "varfloat64_box3";
        case ANARI_FLOAT64_BOX4: return "varfloat64_box4";
        case ANARI_UINT64_REGION1: return "varuint64_region1";
        case ANARI_UINT64_REGION2: return "varuint64_region2";
        case ANARI_UINT64_REGION3: return "varuint64_region3";
        case ANARI_UINT64_REGION4: return "varuint64_region4";
        case ANARI_FLOAT32_MAT2: return "varfloat32_mat2";
        case ANARI_FLOAT32_MAT3: return "varfloat32_mat3";
        case ANARI_FLOAT32_MAT4: return "varfloat32_mat4";
        case ANARI_FLOAT32_MAT2x3: return "varfloat32_mat2x3";
        case ANARI_FLOAT32_MAT3x4: return "varfloat32_mat3x4";
        case ANARI_FLOAT32_QUAT_IJKW: return "varfloat32_quat_ijkw";
        case ANARI_FRAME_COMPLETION_CALLBACK: return "varframe_completion_callback";
        default: return "ANARI_UNKNOWN";
    }
}

inline int isNormalized(ANARIDataType type) {
    switch (type) {
        case ANARI_UNKNOWN: return 0;
        case ANARI_DATA_TYPE: return 0;
        case ANARI_STRING: return 0;
        case ANARI_VOID_POINTER: return 0;
        case ANARI_BOOL: return 0;
        case ANARI_STRING_LIST: return 0;
        case ANARI_DATA_TYPE_LIST: return 0;
        case ANARI_PARAMETER_LIST: return 0;
        case ANARI_FUNCTION_POINTER: return 0;
        case ANARI_MEMORY_DELETER: return 0;
        case ANARI_STATUS_CALLBACK: return 0;
        case ANARI_LIBRARY: return 0;
        case ANARI_DEVICE: return 0;
        case ANARI_OBJECT: return 0;
        case ANARI_ARRAY: return 0;
        case ANARI_ARRAY1D: return 0;
        case ANARI_ARRAY2D: return 0;
        case ANARI_ARRAY3D: return 0;
        case ANARI_CAMERA: return 0;
        case ANARI_FRAME: return 0;
        case ANARI_GEOMETRY: return 0;
        case ANARI_GROUP: return 0;
        case ANARI_INSTANCE: return 0;
        case ANARI_LIGHT: return 0;
        case ANARI_MATERIAL: return 0;
        case ANARI_RENDERER: return 0;
        case ANARI_SURFACE: return 0;
        case ANARI_SAMPLER: return 0;
        case ANARI_SPATIAL_FIELD: return 0;
        case ANARI_VOLUME: return 0;
        case ANARI_WORLD: return 0;
        case ANARI_INT8: return 0;
        case ANARI_INT8_VEC2: return 0;
        case ANARI_INT8_VEC3: return 0;
        case ANARI_INT8_VEC4: return 0;
        case ANARI_UINT8: return 0;
        case ANARI_UINT8_VEC2: return 0;
        case ANARI_UINT8_VEC3: return 0;
        case ANARI_UINT8_VEC4: return 0;
        case ANARI_INT16: return 0;
        case ANARI_INT16_VEC2: return 0;
        case ANARI_INT16_VEC3: return 0;
        case ANARI_INT16_VEC4: return 0;
        case ANARI_UINT16: return 0;
        case ANARI_UINT16_VEC2: return 0;
        case ANARI_UINT16_VEC3: return 0;
        case ANARI_UINT16_VEC4: return 0;
        case ANARI_INT32: return 0;
        case ANARI_INT32_VEC2: return 0;
        case ANARI_INT32_VEC3: return 0;
        case ANARI_INT32_VEC4: return 0;
        case ANARI_UINT32: return 0;
        case ANARI_UINT32_VEC2: return 0;
        case ANARI_UINT32_VEC3: return 0;
        case ANARI_UINT32_VEC4: return 0;
        case ANARI_INT64: return 0;
        case ANARI_INT64_VEC2: return 0;
        case ANARI_INT64_VEC3: return 0;
        case ANARI_INT64_VEC4: return 0;
        case ANARI_UINT64: return 0;
        case ANARI_UINT64_VEC2: return 0;
        case ANARI_UINT64_VEC3: return 0;
        case ANARI_UINT64_VEC4: return 0;
        case ANARI_FIXED8: return 1;
        case ANARI_FIXED8_VEC2: return 1;
        case ANARI_FIXED8_VEC3: return 1;
        case ANARI_FIXED8_VEC4: return 1;
        case ANARI_UFIXED8: return 1;
        case ANARI_UFIXED8_VEC2: return 1;
        case ANARI_UFIXED8_VEC3: return 1;
        case ANARI_UFIXED8_VEC4: return 1;
        case ANARI_FIXED16: return 1;
        case ANARI_FIXED16_VEC2: return 1;
        case ANARI_FIXED16_VEC3: return 1;
        case ANARI_FIXED16_VEC4: return 1;
        case ANARI_UFIXED16: return 1;
        case ANARI_UFIXED16_VEC2: return 1;
        case ANARI_UFIXED16_VEC3: return 1;
        case ANARI_UFIXED16_VEC4: return 1;
        case ANARI_FIXED32: return 1;
        case ANARI_FIXED32_VEC2: return 1;
        case ANARI_FIXED32_VEC3: return 1;
        case ANARI_FIXED32_VEC4: return 1;
        case ANARI_UFIXED32: return 1;
        case ANARI_UFIXED32_VEC2: return 1;
        case ANARI_UFIXED32_VEC3: return 1;
        case ANARI_UFIXED32_VEC4: return 1;
        case ANARI_FIXED64: return 1;
        case ANARI_FIXED64_VEC2: return 1;
        case ANARI_FIXED64_VEC3: return 1;
        case ANARI_FIXED64_VEC4: return 1;
        case ANARI_UFIXED64: return 1;
        case ANARI_UFIXED64_VEC2: return 1;
        case ANARI_UFIXED64_VEC3: return 1;
        case ANARI_UFIXED64_VEC4: return 1;
        case ANARI_FLOAT16: return 0;
        case ANARI_FLOAT16_VEC2: return 0;
        case ANARI_FLOAT16_VEC3: return 0;
        case ANARI_FLOAT16_VEC4: return 0;
        case ANARI_FLOAT32: return 0;
        case ANARI_FLOAT32_VEC2: return 0;
        case ANARI_FLOAT32_VEC3: return 0;
        case ANARI_FLOAT32_VEC4: return 0;
        case ANARI_FLOAT64: return 0;
        case ANARI_FLOAT64_VEC2: return 0;
        case ANARI_FLOAT64_VEC3: return 0;
        case ANARI_FLOAT64_VEC4: return 0;
        case ANARI_UFIXED8_RGBA_SRGB: return 1;
        case ANARI_UFIXED8_RGB_SRGB: return 1;
        case ANARI_UFIXED8_RA_SRGB: return 1;
        case ANARI_UFIXED8_R_SRGB: return 1;
        case ANARI_INT32_BOX1: return 0;
        case ANARI_INT32_BOX2: return 0;
        case ANARI_INT32_BOX3: return 0;
        case ANARI_INT32_BOX4: return 0;
        case ANARI_FLOAT32_BOX1: return 0;
        case ANARI_FLOAT32_BOX2: return 0;
        case ANARI_FLOAT32_BOX3: return 0;
        case ANARI_FLOAT32_BOX4: return 0;
        case ANARI_FLOAT64_BOX1: return 0;
        case ANARI_FLOAT64_BOX2: return 0;
        case ANARI_FLOAT64_BOX3: return 0;
        case ANARI_FLOAT64_BOX4: return 0;
        case ANARI_UINT64_REGION1: return 0;
        case ANARI_UINT64_REGION2: return 0;
        case ANARI_UINT64_REGION3: return 0;
        case ANARI_UINT64_REGION4: return 0;
        case ANARI_FLOAT32_MAT2: return 0;
        case ANARI_FLOAT32_MAT3: return 0;
        case ANARI_FLOAT32_MAT4: return 0;
        case ANARI_FLOAT32_MAT2x3: return 0;
        case ANARI_FLOAT32_MAT3x4: return 0;
        case ANARI_FLOAT32_QUAT_IJKW: return 0;
        case ANARI_FRAME_COMPLETION_CALLBACK: return 0;
        default: return 0;
    }
}
}
